/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.modules.gunpack.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;

public class NTGLPackResources
implements PackResources {
    private final FileSystem fs;
    private final String type;
    private final String packId;

    public NTGLPackResources(Path path, String type) throws IOException {
        this.fs = FileSystems.newFileSystem(path, (ClassLoader)null);
        this.type = type;
        this.packId = "ntgl_" + path.getFileName().toString().replace(".zip", "");
    }

    public NTGLPackResources(Path path, String type, String packId) throws IOException {
        this.fs = FileSystems.newFileSystem(path, (ClassLoader)null);
        this.type = type;
        this.packId = packId;
    }

    public IoSupplier<InputStream> m_8017_(String ... paths) {
        Path path = this.fs.getPath(String.join((CharSequence)"/", paths), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return () -> Files.newInputStream(path, new OpenOption[0]);
        }
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation location) {
        Path path = this.fs.getPath(this.type, location.m_135827_(), location.m_135815_());
        if (Files.exists(path, new LinkOption[0])) {
            return () -> Files.newInputStream(path, new OpenOption[0]);
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput output) {
        Path root = this.fs.getPath(this.type, namespace, path);
        if (Files.exists(root, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(root, Integer.MAX_VALUE, new FileVisitOption[0]);){
                walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    String relative = root.relativize((Path)file).toString().replace('\\', '/');
                    ResourceLocation loc = ResourceLocation.m_214293_((String)namespace, (String)(path + "/" + relative));
                    output.accept((Object)loc, () -> Files.newInputStream(file, new OpenOption[0]));
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Set<String> m_5698_(PackType packType) {
        try {
            Path root = this.fs.getPath(this.type, new String[0]);
            if (Files.exists(root, new LinkOption[0])) {
                return Files.list(root).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toSet());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.emptySet();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) throws IOException {
        IoSupplier<InputStream> supplier;
        if (serializer.m_7991_().equals("pack") && (supplier = this.m_8017_("pack.mcmeta")) != null) {
            try (InputStream stream = (InputStream)supplier.m_247737_();){
                Object object = AbstractPackResources.m_10214_(serializer, (InputStream)stream);
                return (T)object;
            }
        }
        return null;
    }

    public String m_5542_() {
        return this.packId;
    }

    public void close() {
        try {
            this.fs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isHidden() {
        return false;
    }
}

