/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.onlyhammersandexcavators.event;

import com.blocklegend001.onlyhammersandexcavators.item.custom.Excavator;
import com.blocklegend001.onlyhammersandexcavators.utils.RadiusMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="onlyhammersandexcavators", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEventsExcavator {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static boolean onExcavatorUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.m_21205_();
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Item item = mainHandItem.m_41720_();
        if (!(item instanceof Excavator)) {
            return true;
        }
        Excavator excavator = (Excavator)item;
        if (HARVESTED_BLOCKS.contains(event.getPos())) {
            return true;
        }
        boolean isSneaking = player.m_6047_() || player.m_6144_();
        HARVESTED_BLOCKS.add(event.getPos());
        try {
            int radius = isSneaking ? 0 : RadiusMap.getExcavatorRadius().get(mainHandItem.m_41720_());
            for (BlockPos targetPos : Excavator.getBlocksToBeDestroyed(radius, event.getPos(), serverPlayer)) {
                if (targetPos.equals((Object)event.getPos()) || HARVESTED_BLOCKS.contains(targetPos) || !excavator.isCorrectToolForDrops(mainHandItem, event.getLevel().m_8055_(targetPos))) continue;
                HARVESTED_BLOCKS.add(targetPos);
                serverPlayer.f_8941_.m_9280_(targetPos);
                HARVESTED_BLOCKS.remove(targetPos);
            }
        }
        finally {
            HARVESTED_BLOCKS.remove(event.getPos());
        }
        return true;
    }
}

