/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.petrolpark.Petrolpark;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class GsonSerializableCodecs {
    public static final Codec<NumberProvider> NUMBER_PROVIDER = GsonSerializableCodecs.GSONserializableCodec("number provider", NumberProvider.class, Deserializers.m_78798_().create());

    public static <GSON_SERIALIZABLE_OBJECT> Codec<GSON_SERIALIZABLE_OBJECT> GSONserializableCodec(String name, Class<GSON_SERIALIZABLE_OBJECT> jsonSerializableObjectClass, Gson gson) {
        gson.getAdapter(jsonSerializableObjectClass);
        return Codec.PASSTHROUGH.flatXmap(d -> {
            try {
                Object object = gson.fromJson(GsonSerializableCodecs.getJson(d), jsonSerializableObjectClass);
                return DataResult.success((Object)object);
            }
            catch (JsonSyntaxException e) {
                Petrolpark.LOGGER.warn("Unable to decode " + name, (Throwable)e);
                return DataResult.error(e::getMessage);
            }
        }, object -> {
            try {
                JsonElement element = gson.toJsonTree(object);
                return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
            }
            catch (JsonSyntaxException e) {
                Petrolpark.LOGGER.warn("Unable to encode " + name, (Throwable)e);
                return DataResult.error(e::getMessage);
            }
        });
    }

    protected static <U> JsonElement getJson(Dynamic<?> dynamic) {
        JsonElement jsonElement;
        Dynamic<?> typed = dynamic;
        Object object = typed.getValue();
        return object instanceof JsonElement ? (jsonElement = (JsonElement)object) : (JsonElement)typed.getOps().convertTo((DynamicOps)JsonOps.INSTANCE, typed.getValue());
    }
}

