/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.recipe.ingredient.randomizer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.petrolpark.recipe.ingredient.randomizer.IngredientRandomizer;
import com.petrolpark.recipe.ingredient.randomizer.IngredientRandomizerType;
import com.petrolpark.recipe.ingredient.randomizer.IngredientRandomizerTypes;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.GsonAdapterFactory;
import net.minecraft.world.level.storage.loot.LootContext;

public class FromArrayIngredientRandomizer
implements IngredientRandomizer {
    public final Ingredient[] ingredients;

    public FromArrayIngredientRandomizer(Ingredient[] ingredients) {
        this.ingredients = ingredients;
    }

    @Override
    public Ingredient generate(LootContext context) {
        if (this.ingredients.length == 1) {
            return this.ingredients[0];
        }
        return this.ingredients[context.m_230907_().m_188503_(this.ingredients.length)];
    }

    @Override
    public IngredientRandomizerType getType() {
        return (IngredientRandomizerType)((Object)IngredientRandomizerTypes.FROM_ARRAY.get());
    }

    public JsonArray asJsonArray() {
        JsonArray array = new JsonArray(this.ingredients.length);
        for (Ingredient ingredient : this.ingredients) {
            array.add(ingredient.m_43942_());
        }
        return array;
    }

    public static FromArrayIngredientRandomizer fromJsonArray(JsonArray array) throws JsonSyntaxException {
        Ingredient[] ingredients = new Ingredient[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            ingredients[i] = Ingredient.m_43917_((JsonElement)array.get(i));
        }
        return new FromArrayIngredientRandomizer(ingredients);
    }

    public static class InlineSerializer
    implements GsonAdapterFactory.InlineSerializer<FromArrayIngredientRandomizer> {
        public JsonElement serialize(FromArrayIngredientRandomizer value, JsonSerializationContext context) {
            return value.asJsonArray();
        }

        public FromArrayIngredientRandomizer deserialize(JsonElement json, JsonDeserializationContext context) {
            try {
                return new FromArrayIngredientRandomizer(new Ingredient[]{Ingredient.m_43917_((JsonElement)json)});
            }
            catch (JsonSyntaxException e) {
                return FromArrayIngredientRandomizer.fromJsonArray(GsonHelper.m_13924_((JsonElement)json, (String)"values"));
            }
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<FromArrayIngredientRandomizer> {
        public void serialize(JsonObject json, FromArrayIngredientRandomizer value, JsonSerializationContext serializationContext) {
            json.add("values", (JsonElement)value.asJsonArray());
        }

        public FromArrayIngredientRandomizer deserialize(JsonObject json, JsonDeserializationContext deserializationContext) {
            return FromArrayIngredientRandomizer.fromJsonArray(GsonHelper.m_13933_((JsonObject)json, (String)"values"));
        }
    }
}

