/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blockentity;

import com.tiviacz.pizzadelight.blockentity.BaseBlockEntity;
import com.tiviacz.pizzadelight.blocks.PizzaBlock;
import com.tiviacz.pizzadelight.blocks.RawPizzaBlock;
import com.tiviacz.pizzadelight.client.PizzaBakedModel;
import com.tiviacz.pizzadelight.common.PizzaBlockCalculator;
import com.tiviacz.pizzadelight.container.PizzaMenu;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModBlocks;
import com.tiviacz.pizzadelight.init.ModItems;
import com.tiviacz.pizzadelight.tags.ModTags;
import com.tiviacz.pizzadelight.util.NBTUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class PizzaBlockEntity
extends BaseBlockEntity
implements MenuProvider,
Nameable {
    public ItemStackHandler inventory = this.createHandler((NonNullList<ItemStack>)NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_));
    private Component customName = null;
    private int bakingTime = 0;
    private final int BASE_BAKING_TIME = 600;
    private int selectedSlot = 0;
    private final LazyOptional<ItemStackHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    private static final String BAKING_TIME = "BakingTime";
    private static final String CUSTOM_NAME = "CustomName";

    public PizzaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.PIZZA.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.bakingTime = compound.m_128451_(BAKING_TIME);
        if (compound.m_128425_(CUSTOM_NAME, 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_(CUSTOM_NAME));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_(BAKING_TIME, this.bakingTime);
        if (this.customName != null) {
            compound.m_128359_(CUSTOM_NAME, Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public ItemStack cloneToItemStack(ItemStack stack) {
        if (this.inventory != null) {
            NBTUtils.saveInventoryToStack(stack, this.inventory);
        }
        if (this.customName != null) {
            stack.m_41714_(this.customName);
        }
        return stack;
    }

    public ItemStack getSlice(ItemStack stack) {
        if (this.inventory != null) {
            NBTUtils.saveInventoryToStack(stack, this.inventory);
        }
        PizzaBlockCalculator calculator = new PizzaBlockCalculator(this.inventory);
        calculator.process();
        int allNutrition = (calculator.getHunger() + 3) / 4 * 4;
        NBTUtils.setHunger(stack, allNutrition / 4);
        NBTUtils.setSaturation(stack, calculator.getSaturation());
        NBTUtils.setEffects(stack, calculator.getEffects());
        return stack;
    }

    public void tryRemoving(Player player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)stack);
        }
    }

    public InteractionResult manageIngredients(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack stack = player.m_21120_(hand);
            if (this.isRaw() && !this.isBaking()) {
                if (stack.m_41619_()) {
                    for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                        ItemStack nonEmpty = this.inventory.getStackInSlot(i);
                        if (nonEmpty.m_41619_()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (!this.inventory.getStackInSlot(this.selectedSlot).m_41619_()) {
                        ItemStack modifiedCopy = this.inventory.getStackInSlot(this.selectedSlot).m_41777_();
                        if (this.selectedSlot != 9) {
                            this.tryRemoving(player, modifiedCopy);
                        }
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
                        this.removeFromSlot(this.selectedSlot);
                        this.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        ItemStack empty = this.inventory.getStackInSlot(i);
                        if (!empty.m_41619_()) continue;
                        this.selectedSlot = i;
                        break;
                    }
                    if (stack.m_41720_() instanceof PotionItem) {
                        ItemStack modifiedCopy = stack.m_41777_();
                        modifiedCopy.m_41764_(1);
                        this.inventory.setStackInSlot(9, modifiedCopy);
                        stack.m_41774_(player.m_7500_() ? 0 : 1);
                        ItemStack container = PizzaMenu.getItemStack(modifiedCopy);
                        this.tryRemoving(player, container);
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_144066_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
                        this.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                    if (this.selectedSlot < 9 && this.canAddIngredient(stack, this.selectedSlot)) {
                        ItemStack modifiedCopy = stack.m_41777_();
                        modifiedCopy.m_41764_(1);
                        this.inventory.setStackInSlot(this.selectedSlot, modifiedCopy);
                        stack.m_41774_(player.m_7500_() ? 0 : 1);
                        this.f_58857_.m_5594_(player, this.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f + this.f_58857_.f_46441_.m_188501_());
                        this.m_6596_();
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean isBaking() {
        return this.bakingTime > 0;
    }

    public int getBakingTime() {
        return this.bakingTime;
    }

    public int getDefaultBakingTime() {
        return 600;
    }

    public boolean isRaw() {
        if (this.f_58857_ == null) {
            return true;
        }
        return this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof RawPizzaBlock;
    }

    public int getCalculatedBakingTime() {
        int bakingTime = this.getDefaultBakingTime();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            bakingTime += 20 * this.inventory.getStackInSlot(i).m_41613_();
        }
        return bakingTime;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PizzaBlockEntity blockEntity) {
        boolean save = false;
        if (blockEntity.isRaw() && blockEntity.bakingTime == 0 && level.m_8055_(pos.m_7495_()).m_204336_(vectorwing.farmersdelight.common.tag.ModTags.HEAT_SOURCES)) {
            blockEntity.bakingTime = 1;
            save = true;
        }
        if (blockEntity.isBaking()) {
            ++blockEntity.bakingTime;
            save = true;
            if (blockEntity.getBakingTime() >= blockEntity.getCalculatedBakingTime() && !level.f_46443_) {
                level.m_46597_(blockEntity.m_58899_(), ((Block)ModBlocks.PIZZA.get()).m_49966_());
                blockEntity.bakingTime = 0;
            }
            if (!level.m_8055_(pos.m_7495_()).m_204336_(vectorwing.farmersdelight.common.tag.ModTags.HEAT_SOURCES)) {
                blockEntity.bakingTime = 0;
            }
        }
        if (save) {
            blockEntity.m_6596_();
        }
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public boolean canAddIngredient(ItemStack stack, int slot) {
        if (stack.m_220173_().m_203373_(new ResourceLocation("some_assembly_required", "sandwich"))) {
            return false;
        }
        if (stack.m_41720_().m_41473_() != null || stack.m_204117_(ModTags.INGREDIENTS)) {
            return this.inventory.getStackInSlot(slot).m_41619_();
        }
        return false;
    }

    public void removeFromSlot(int slot) {
        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> contents) {
        return new ItemStackHandler(contents){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (PizzaBlockEntity.this.isRaw() && !PizzaBlockEntity.this.isBaking()) {
                    return PizzaBlockEntity.this.canAddIngredient(stack, slot);
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                if (PizzaBlockEntity.this.m_58900_().m_60734_() instanceof RawPizzaBlock) {
                    PizzaBlockEntity.this.m_6596_();
                    PizzaBlockEntity.this.requestModelDataUpdate();
                }
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new PizzaMenu(id, playerInventory, this);
    }

    public void openGUI(Player player, MenuProvider menuSupplier, BlockPos pos) {
        if (!player.m_9236_().f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menuSupplier, (BlockPos)pos);
        }
    }

    @Nonnull
    public ModelData getModelData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(PizzaBakedModel.LAYER_PROVIDERS, Optional.of(this.getInventory()));
        builder.with(PizzaBakedModel.INTEGER_PROPERTY, Optional.of(this.m_58900_().m_60734_() == ModBlocks.PIZZA.get() ? (Integer)this.m_58900_().m_61143_((Property)PizzaBlock.SLICES) : Integer.valueOf(0)));
        builder.with(PizzaBakedModel.IS_RAW, Optional.of(this.isRaw()));
        ModelData modelData = builder.build();
        return modelData;
    }

    public ModelData getItemStackModelData(ItemStack stack) {
        this.m_142466_(stack.m_41784_());
        ModelData.Builder builder = ModelData.builder();
        builder.with(PizzaBakedModel.LAYER_PROVIDERS, Optional.of(this.getInventory()));
        builder.with(PizzaBakedModel.INTEGER_PROPERTY, Optional.of(0));
        builder.with(PizzaBakedModel.IS_RAW, Optional.of(stack.m_41720_() == ModItems.RAW_PIZZA.get()));
        return builder.build();
    }
}

