/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.blocks;

import com.tiviacz.pizzadelight.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzadelight.blocks.AbstractPizzaBlock;
import com.tiviacz.pizzadelight.blocks.PizzaBlock;
import com.tiviacz.pizzadelight.init.ModBlockEntityTypes;
import com.tiviacz.pizzadelight.init.ModSounds;
import com.tiviacz.pizzadelight.items.PizzaPeelItem;
import com.tiviacz.pizzadelight.util.RenderUtils;
import com.tiviacz.pizzadelight.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RawPizzaBlock
extends AbstractPizzaBlock {
    public RawPizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult interactionResult;
        ItemStack heldStack = player.m_21120_(handIn);
        if (heldStack.m_41720_() instanceof PizzaPeelItem) {
            interactionResult = this.pickUpPizza(level, pos, state, player.m_6350_().m_122424_());
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PizzaBlockEntity) {
                PizzaBlockEntity pizzaBLockEntity = (PizzaBlockEntity)blockEntity;
                interactionResult = pizzaBLockEntity.manageIngredients(player, handIn);
            } else {
                interactionResult = InteractionResult.PASS;
            }
        }
        return interactionResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        PizzaBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof PizzaBlockEntity && (blockEntity = (PizzaBlockEntity)blockEntity2).isBaking()) {
            if (rand.m_188500_() < 0.3) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)ModSounds.BLOCK_PIZZA_SIZZLING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (rand.m_188500_() > 0.5) {
                double[] particlePos = RenderUtils.getPosRandomAboveBlockHorizontal(level, pos);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, particlePos[0], (double)pos.m_123342_() + 0.4, particlePos[1], 0.0, 0.025, 0.0);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PizzaBlockEntity) {
            PizzaBlockEntity blockEntity2 = (PizzaBlockEntity)blockEntity;
            if (!player.m_7500_() && !(player.m_21205_().m_41720_() instanceof PizzaPeelItem)) {
                for (int i = 0; i < blockEntity2.getInventory().getSlots(); ++i) {
                    if (blockEntity2.getInventory().getStackInSlot(i).m_41619_()) continue;
                    Utils.spawnItemStackInWorld(level, pos, blockEntity2.getInventory().getStackInSlot(i));
                    blockEntity2.getInventory().setStackInSlot(i, ItemStack.f_41583_);
                }
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof PizzaBlock)) {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return Utils.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.PIZZA.get(), PizzaBlockEntity::tick);
    }
}

