/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzadelight.network;

import com.tiviacz.pizzadelight.container.PizzaStationMenu;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundRenamePizzaPacket {
    private final String name;

    public ServerboundRenamePizzaPacket(String name) {
        this.name = name;
    }

    public static ServerboundRenamePizzaPacket decode(FriendlyByteBuf buffer) {
        String name = buffer.m_130277_();
        return new ServerboundRenamePizzaPacket(name);
    }

    public static void encode(ServerboundRenamePizzaPacket message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.name);
    }

    public static void handle(ServerboundRenamePizzaPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            AbstractContainerMenu menu = serverPlayer.f_36096_;
            if (menu instanceof PizzaStationMenu) {
                PizzaStationMenu stationMenu = (PizzaStationMenu)menu;
                if (!stationMenu.m_6875_((Player)serverPlayer)) {
                    return;
                }
                String s = SharedConstants.m_136190_((String)message.name);
                if (s.length() <= 50) {
                    stationMenu.setItemName(s);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

