/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node.cover;

import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.CableNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.item.CoverItem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CoverManager {
    public static final ModelProperty<CoverManager> PROPERTY = new ModelProperty();
    private static final String NBT_DIRECTION = "Direction";
    private static final String NBT_ITEM = "Item";
    private static final String NBT_TYPE = "Type";
    public static String NBT_COVER_MANAGER = "Cover";
    private Map<Direction, Cover> covers = new HashMap<Direction, Cover>();
    private NetworkNode node;

    public CoverManager(NetworkNode node) {
        this.node = node;
    }

    public static boolean isValidCover(ItemStack item) {
        if (item.m_41619_()) {
            return false;
        }
        Block block = CoverManager.getBlock(item);
        BlockState state = CoverManager.getBlockState(item);
        return block != null && state != null && CoverManager.isModelSupported(state) && !block.m_6724_(state) && !(block instanceof EntityBlock) && !state.m_60787_();
    }

    private static boolean isModelSupported(BlockState state) {
        if (state.m_60799_() != RenderShape.MODEL) {
            return false;
        }
        return state.m_60815_();
    }

    @Nullable
    public static Block getBlock(ItemStack item) {
        if (item.m_41619_()) {
            return null;
        }
        Block block = Block.m_49814_((Item)item.m_41720_());
        if (block == Blocks.f_50016_) {
            return null;
        }
        return block;
    }

    @Nullable
    public static BlockState getBlockState(ItemStack item) {
        Block block = CoverManager.getBlock(item);
        if (block == null) {
            return null;
        }
        return block.m_49966_();
    }

    @Nullable
    public Cover getCover(Direction facing) {
        return this.covers.get(facing);
    }

    public boolean hasCover(Direction facing) {
        return this.covers.containsKey(facing);
    }

    public boolean setCover(Direction facing, @Nullable Cover cover) {
        if (cover == null || CoverManager.isValidCover(cover.getStack()) && !this.hasCover(facing)) {
            if (cover != null && !(this.node instanceof CableNetworkNode) && facing == this.node.getDirection() && cover.getType() != CoverType.HOLLOW) {
                return false;
            }
            if (cover == null) {
                this.covers.remove(facing);
            } else {
                this.covers.put(facing, cover);
            }
            this.node.markDirty();
            if (this.node.getNetwork() != null) {
                this.node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, this.node.getNetwork().getLevel(), this.node.getNetwork().getPosition());
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Cover removeCover(Direction direction) {
        if (this.hasCover(direction)) {
            Cover cover = this.covers.remove(direction);
            this.node.markDirty();
            if (this.node.getNetwork() != null) {
                this.node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, this.node.getNetwork().getLevel(), this.node.getNetwork().getPosition());
            }
            return cover;
        }
        return null;
    }

    public void readFromNbt(CompoundTag nbt) {
        this.covers.clear();
        for (String s : nbt.m_128431_()) {
            int type;
            CompoundTag tag = nbt.m_128469_(s);
            if (!tag.m_128441_(NBT_DIRECTION) || !tag.m_128441_(NBT_ITEM)) continue;
            Direction direction = Direction.m_122376_((int)tag.m_128451_(NBT_DIRECTION));
            ItemStack item = ItemStack.m_41712_((CompoundTag)tag.m_128469_(NBT_ITEM));
            int n = type = tag.m_128441_(NBT_TYPE) ? tag.m_128451_(NBT_TYPE) : 0;
            if (type >= CoverType.values().length) {
                type = 0;
            }
            if (!CoverManager.isValidCover(item)) continue;
            this.covers.put(direction, new Cover(item, CoverType.values()[type]));
        }
    }

    public CompoundTag writeToNbt() {
        CompoundTag list = new CompoundTag();
        for (Map.Entry<Direction, Cover> entry : this.covers.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(NBT_DIRECTION, entry.getKey().ordinal());
            tag.m_128365_(NBT_ITEM, (Tag)entry.getValue().getStack().serializeNBT());
            tag.m_128405_(NBT_TYPE, entry.getValue().getType().ordinal());
            list.m_128365_("" + entry.getKey().ordinal(), (Tag)tag);
        }
        return list;
    }

    public IItemHandlerModifiable getAsInventory() {
        ItemStackHandler handler = new ItemStackHandler(this.covers.size());
        int i = 0;
        for (Map.Entry<Direction, Cover> entry : this.covers.entrySet()) {
            ItemStack cover = entry.getValue().getType().createStack();
            CoverItem.setItem(cover, entry.getValue().getStack());
            handler.setStackInSlot(i++, cover);
        }
        return handler;
    }
}

