/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.ElectricityGeneratorMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ElectricityGeneratorScreen
extends AbstractContainerScreen<ElectricityGeneratorMenu> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/electricity_generator.png");
    protected OnOffSlider slider;

    public ElectricityGeneratorScreen(ElectricityGeneratorMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.slider = (OnOffSlider)this.m_142416_((GuiEventListener)new OnOffSlider(this.f_97735_ + this.f_97726_ - 22 - 6, this.f_97736_ + 5, (Component)Utils.translation("gui", "generator_toggle", new Object[0]), btn -> Network.getPlay().sendToServer((IMessage)new MessageTogglePower())));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((ElectricityGeneratorMenu)this.f_97732_).isEnabled());
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((ElectricityGeneratorMenu)this.f_97732_).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.f_97732_).getTotalEnergy() > 0) {
            float normalEnergy = (float)((ElectricityGeneratorMenu)this.f_97732_).getEnergy() / (float)((ElectricityGeneratorMenu)this.f_97732_).getTotalEnergy();
            int v = (int)Math.ceil(14.0f * normalEnergy);
            graphics.m_280218_(TEXTURE, this.f_97735_ + 26, this.f_97736_ + 25 + 14 - v, 176, 14 - v, 14, v);
        }
        Status status = this.getStatus();
        graphics.m_280163_(IconButton.ICON_TEXTURES, this.f_97735_ + 66, this.f_97736_ + 29, (float)status.iconU, (float)status.iconV, 10, 10, 64, 64);
        graphics.m_280163_(IconButton.ICON_TEXTURES, this.f_97735_ + 66, this.f_97736_ + 46, 0.0f, 10.0f, 10, 10, 64, 64);
        if (((ElectricityGeneratorMenu)this.f_97732_).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.f_97732_).getTotalEnergy() > 0 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.f_97735_ + 26, this.f_97736_ + 25, 14, 14)) {
            this.m_257404_((Component)Utils.translation("gui", "progress", ((ElectricityGeneratorMenu)this.f_97732_).getEnergy(), Components.GUI_SLASH, ((ElectricityGeneratorMenu)this.f_97732_).getTotalEnergy()));
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        Status status = this.getStatus();
        graphics.m_280614_(this.f_96547_, status.label, 80, 30, status.textColour, true);
        Pair<Component, Integer> pair = this.getNodeCount();
        graphics.m_280614_(this.f_96547_, (Component)pair.left(), 80, 47, ((Integer)pair.right()).intValue(), true);
    }

    private Pair<Component, Integer> getNodeCount() {
        int nodeCount = ((ElectricityGeneratorMenu)this.f_97732_).getNodeCount();
        int maxNodeCount = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
        MutableComponent label = Utils.translation("gui", "node_count", nodeCount, maxNodeCount);
        int textColour = nodeCount > maxNodeCount ? -3983818 : -1;
        return Pair.of((Object)label, (Object)textColour);
    }

    private Status getStatus() {
        if (((ElectricityGeneratorMenu)this.f_97732_).isOverloaded()) {
            return Status.OVERLOADED;
        }
        if (((ElectricityGeneratorMenu)this.f_97732_).isEnabled()) {
            if (((ElectricityGeneratorMenu)this.f_97732_).isPowered()) {
                return Status.ONLINE;
            }
            if (((ElectricityGeneratorMenu)this.f_97732_).getEnergy() == 0) {
                return Status.NO_FUEL;
            }
        }
        return Status.OFFLINE;
    }

    private static enum Status {
        ONLINE(-8799453, 50, 0, (Component)Utils.translation("gui", "status.online", new Object[0])),
        OFFLINE(-3983818, 40, 0, (Component)Utils.translation("gui", "status.offline", new Object[0])),
        OVERLOADED(-2711764, 30, 0, (Component)Utils.translation("gui", "status.overloaded", new Object[0])),
        NO_FUEL(-2711764, 10, 10, (Component)Utils.translation("gui", "status.no_fuel", new Object[0]));

        private final int textColour;
        private final int iconU;
        private final int iconV;
        private final Component label;

        private Status(int textColour, int iconU, int iconV, Component label) {
            this.textColour = textColour;
            this.iconU = iconU;
            this.iconV = iconV;
            this.label = label;
        }
    }
}

