/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.gui;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CatBookScreen
extends Screen {
    private static final int bookImageHeight = 182;
    private static final int bookImageWidth = 281;
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("simplycats", "textures/gui/cat_book.png");
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private Level world;
    private int currPage;
    private final ListTag bookPages = new ListTag();
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    public SimplyCatEntity cat;
    protected int catHealth;

    public CatBookScreen(CompoundTag bookTag, Level world, int catInList) {
        this(bookTag, world);
        this.currPage = catInList;
    }

    public CatBookScreen(CompoundTag bookTag, Level world) {
        super(GameNarrator.f_93310_);
        if (bookTag != null && !bookTag.m_128456_()) {
            ListTag pages = bookTag.m_128437_("pages", 10).m_6426_();
            this.bookPages.addAll((Collection)pages);
            this.world = world;
        }
    }

    protected void m_7856_() {
        int centerX = (this.f_96543_ - 281) / 2;
        this.buttonNextPage = (NextPageButton)this.m_142416_((GuiEventListener)new NextPageButton(centerX + 236, 157, true, button -> this.pageForward()));
        this.buttonPreviousPage = (NextPageButton)this.m_142416_((GuiEventListener)new NextPageButton(centerX + 25, 157, false, button -> this.pageBack()));
        this.updateButtons();
    }

    private void updateButtons() {
        this.cat = (SimplyCatEntity)EntityType.m_20645_((CompoundTag)this.bookPages.m_128728_(this.currPage), (Level)this.world, entity1 -> entity1);
        this.buttonNextPage.f_93624_ = this.currPage < this.bookPages.size() - 1;
        this.buttonPreviousPage.f_93624_ = this.currPage > 0;
    }

    private void pageBack() {
        if (this.currPage > 0) {
            --this.currPage;
        }
        this.updateButtons();
    }

    private void pageForward() {
        if (this.currPage < this.bookPages.size() - 1) {
            ++this.currPage;
        }
        this.updateButtons();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int leftX = (this.f_96543_ - 281) / 2;
        int leftCenterX = leftX + 70;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        guiGraphics.m_280163_(BG_TEXTURE, leftX, 2, 0.0f, 0.0f, 281, 182, 288, 256);
        if (this.bookPages.get(this.currPage) != null || !this.bookPages.m_128728_(this.currPage).m_128456_() || this.cat != null) {
            InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(leftX + 40), (int)74, (int)50, (float)(leftX + 51 - mouseX), (float)(50 - mouseY), (LivingEntity)this.cat);
            int nameWidth = this.f_96547_.m_92852_((FormattedText)this.cat.m_7755_());
            guiGraphics.m_280614_(this.f_96547_, this.cat.m_7755_(), leftCenterX - nameWidth / 2, 14, 0, false);
            MutableComponent sex = Component.m_237113_((String)(Component.m_237115_((String)(this.cat.isFixed() ? "cat.fixed.name" : "cat.intact.name")).getString() + " " + Genetics.Sex.getPrettyName(this.bookPages.m_128728_(this.currPage).m_128461_("Phaeomelanin")).getString()));
            guiGraphics.m_280614_(this.f_96547_, (Component)sex, leftX + 66, 28, 0, false);
            this.renderCatHealth(guiGraphics, leftX + 66, 42);
            if (this.cat.m_21824_()) {
                String ownerName = this.cat.getOwnerName().getString();
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"tooltip.pet_carrier.owner", (Object[])new Object[]{ownerName}), leftX + 16, 84, 0, false);
            } else {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"entity.simplycats.cat.untamed"), leftX + 16, 84, 0, false);
            }
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)Genetics.getPhenotypeDescription(this.bookPages.m_128728_(this.currPage), false), leftX + 16, 98, 120, 0);
            String eyeColor = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("EyeColor");
            String furLength = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("FurLength");
            String eumelanin = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Eumelanin");
            String phaeomelanin = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Phaeomelanin");
            String dilution = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Dilution");
            String diluteMod = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("DiluteMod");
            String agouti = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Agouti");
            String tabby = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Tabby");
            String spotted = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Spotted");
            String ticked = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Ticked");
            String inhibitor = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Inhibitor");
            String colorpoint = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Colorpoint");
            String white = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("White");
            String bobtail = ChatFormatting.GRAY + this.bookPages.m_128728_(this.currPage).m_128461_("Bobtail");
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.eye_color", (Object[])new Object[]{eyeColor}), leftX + 152, 19, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.fur_length", (Object[])new Object[]{furLength}), leftX + 152, 29, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.eumelanin", (Object[])new Object[]{eumelanin}), leftX + 152, 39, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.phaeomelanin", (Object[])new Object[]{phaeomelanin}), leftX + 152, 49, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.dilute", (Object[])new Object[]{dilution}), leftX + 152, 59, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.dilute_modifier", (Object[])new Object[]{diluteMod}), leftX + 152, 69, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.agouti", (Object[])new Object[]{agouti}), leftX + 152, 79, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.tabby", (Object[])new Object[]{tabby}), leftX + 152, 89, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.spotted", (Object[])new Object[]{spotted}), leftX + 152, 99, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.ticked", (Object[])new Object[]{ticked}), leftX + 152, 109, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.inhibitor", (Object[])new Object[]{inhibitor}), leftX + 152, 119, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.colorpoint", (Object[])new Object[]{colorpoint}), leftX + 152, 129, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.white", (Object[])new Object[]{white}), leftX + 152, 139, 0, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"book.genetics.bobtail", (Object[])new Object[]{bobtail}), leftX + 152, 149, 0, false);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderCatHealth(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.catHealth = Mth.m_14167_((float)this.cat.m_21223_());
        float maxHealth = (float)this.cat.m_21133_(Attributes.f_22276_);
        int l1 = Mth.m_14167_((float)(maxHealth / 2.0f / 10.0f));
        int i2 = Math.max(10 - (l1 - 2), 3);
        for (int wholeHearts = Mth.m_14167_((float)(maxHealth / 2.0f)) - 1; wholeHearts >= 0; --wholeHearts) {
            int textureX = 16;
            int textureY = 0;
            int j4 = Mth.m_14167_((float)((float)(wholeHearts + 1) / 10.0f)) - 1;
            int guiX = x + wholeHearts % 10 * 8;
            int guiY = y - j4 * i2;
            guiGraphics.m_280218_(GUI_ICONS_LOCATION, guiX, guiY, 16 + textureY * 9, 9 * textureY, 9, 9);
            if (wholeHearts * 2 + 1 < this.catHealth) {
                guiGraphics.m_280218_(GUI_ICONS_LOCATION, guiX, guiY, textureX + 36, 9 * textureY, 9, 9);
            }
            if (wholeHearts * 2 + 1 != this.catHealth) continue;
            guiGraphics.m_280218_(GUI_ICONS_LOCATION, guiX, guiY, textureX + 45, 9 * textureY, 9, 9);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class NextPageButton
    extends Button {
        private final boolean isNextButton;

        NextPageButton(int x, int y, boolean nextButton, Button.OnPress pressable) {
            super(x, y, 20, 12, CommonComponents.f_237098_, pressable, f_252438_);
            this.isNextButton = nextButton;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                boolean isButtonPressed = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
                int textureX = 2;
                int textureY = 193;
                if (isButtonPressed) {
                    textureX += 23;
                }
                if (!this.isNextButton) {
                    textureY += 13;
                }
                guiGraphics.m_280163_(BG_TEXTURE, this.m_252754_(), this.m_252907_(), (float)textureX, (float)textureY, this.f_93618_, this.f_93619_, 288, 256);
            }
        }

        public void m_7435_(SoundManager soundHandler) {
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
    }
}

