/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.FilterSlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.EntityMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyCondition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class AlchemyUpgradeContainer
extends UpgradeContainerBase<AlchemyUpgradeWrapper, AlchemyUpgradeContainer> {
    public static final ResourceLocation EMPTY_POTION_SLOT_BACKGROUND = SophisticatedCore.getRL("item/empty_potion_slot");
    public static final String DATA_CONDITION = "condition";
    public static final String DATA_MATCH_ALL = "matchAll";
    private static final String DATA_MATCH_DURATION = "matchDuration";
    public static final String DATA_MATCH_AMPLIFIER = "matchAmplifier";
    private static final String DATA_ENTITY_MATCH = "entityMatch";

    public AlchemyUpgradeContainer(Player player, int upgradeContainerId, AlchemyUpgradeWrapper upgradeWrapper, UpgradeContainerType<AlchemyUpgradeWrapper, AlchemyUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        InventoryHelper.iterate((IItemHandler)upgradeWrapper.getFilterHandler(), (slot, stack) -> this.slots.add(new FilterSlotItemHandler(upgradeWrapper::getFilterHandler, (int)slot, 0, 0, (Integer)slot){
            final /* synthetic */ Integer val$slot;
            {
                this.val$slot = n;
                super(itemHandlerSupplier, slot, xPosition, yPosition);
            }

            @Override
            public boolean m_8010_(Player player) {
                return false;
            }

            @Override
            public boolean m_5857_(ItemStack stack) {
                return stack.m_41619_() || this.getItemHandler().isItemValid(this.val$slot.intValue(), stack);
            }
        }.setBackground(InventoryMenu.f_39692_, EMPTY_POTION_SLOT_BACKGROUND)));
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_CONDITION)) {
            NBTHelper.getEnumConstant(data, DATA_CONDITION, AlchemyCondition::fromName).ifPresent(condition -> this.setConditionValue(data.m_128451_("slot"), (AlchemyCondition)((Object)condition), data.m_128457_("value")));
        } else if (data.m_128441_(DATA_MATCH_ALL)) {
            this.setMatchAll(data.m_128471_(DATA_MATCH_ALL));
        } else if (data.m_128441_(DATA_MATCH_DURATION)) {
            this.setMatchDuration(data.m_128471_(DATA_MATCH_DURATION));
        } else if (data.m_128441_(DATA_MATCH_AMPLIFIER)) {
            this.setMatchAmplifier(data.m_128471_(DATA_MATCH_AMPLIFIER));
        } else if (data.m_128441_(DATA_ENTITY_MATCH)) {
            NBTHelper.getEnumConstant(data, DATA_ENTITY_MATCH, EntityMatch::fromName).ifPresent(this::setEntityMatch);
        }
    }

    private void setConditionValue(int slot, AlchemyCondition enumConstant, float value) {
        ((AlchemyUpgradeWrapper)this.upgradeWrapper).setConditionValue(slot, enumConstant, value);
    }

    public AlchemyCondition getCondition(int slot) {
        return ((AlchemyUpgradeWrapper)this.getUpgradeWrapper()).getCondition(slot);
    }

    public boolean hasNoFilter(int slot) {
        return ((Slot)this.slots.get(slot)).m_7993_().m_41619_();
    }

    public float getValue(int slot) {
        return ((AlchemyUpgradeWrapper)this.getUpgradeWrapper()).getValue(slot);
    }

    public void toggleCondition(int slot) {
        if (((AlchemyUpgradeWrapper)this.upgradeWrapper).getFilterHandler().getStackInSlot(slot).m_41619_()) {
            return;
        }
        AlchemyCondition condition = ((AlchemyUpgradeWrapper)this.upgradeWrapper).getCondition(slot).next();
        float value = condition.defaultValue();
        this.setConditionValue(slot, condition, value);
        this.sendConditionValue(slot, condition, value);
    }

    private void sendConditionValue(int slot, AlchemyCondition condition, float value) {
        this.sendDataToServer(() -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            NBTHelper.putEnumConstant(tag, DATA_CONDITION, condition);
            tag.m_128350_("value", value);
            return tag;
        });
    }

    public void setValue(int slot, float value) {
        AlchemyCondition condition = ((AlchemyUpgradeWrapper)this.upgradeWrapper).getCondition(slot);
        this.setConditionValue(slot, condition, value);
        this.sendConditionValue(slot, condition, value);
    }

    public void toggleMatchAll() {
        this.setMatchAll(!((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchAllEffects());
        this.sendBooleanToServer(DATA_MATCH_ALL, ((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchAllEffects());
    }

    private void setMatchAll(boolean matchAllEffects) {
        ((AlchemyUpgradeWrapper)this.upgradeWrapper).setMatchAllEffects(matchAllEffects);
    }

    public Boolean shouldMatchAll() {
        return ((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchAllEffects();
    }

    public void toggleMatchDuration() {
        this.setMatchDuration(!((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchEffectDuration());
        this.sendBooleanToServer(DATA_MATCH_DURATION, ((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchEffectDuration());
    }

    private void setMatchDuration(boolean matchDuration) {
        ((AlchemyUpgradeWrapper)this.upgradeWrapper).setMatchEffectDuration(matchDuration);
    }

    public boolean shouldMatchDuration() {
        return ((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchEffectDuration();
    }

    public void toggleMatchAmplifier() {
        this.setMatchAmplifier(!((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchEffectAmplifier());
        this.sendBooleanToServer(DATA_MATCH_AMPLIFIER, ((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchEffectAmplifier());
    }

    private void setMatchAmplifier(boolean matchAmplifier) {
        ((AlchemyUpgradeWrapper)this.upgradeWrapper).setMatchEffectAmplifier(matchAmplifier);
    }

    public boolean shouldMatchAmplifier() {
        return ((AlchemyUpgradeWrapper)this.upgradeWrapper).shouldMatchEffectAmplifier();
    }

    public void toggleEntityMatch() {
        this.setEntityMatch(this.getEntityMatch().next());
        this.sendDataToServer(() -> {
            CompoundTag tag = new CompoundTag();
            NBTHelper.putEnumConstant(tag, DATA_ENTITY_MATCH, this.getEntityMatch());
            return tag;
        });
    }

    private void setEntityMatch(EntityMatch entityMatch) {
        ((AlchemyUpgradeWrapper)this.upgradeWrapper).setEntityMatch(entityMatch);
    }

    public EntityMatch getEntityMatch() {
        return ((AlchemyUpgradeWrapper)this.upgradeWrapper).getEntityMatch();
    }

    public boolean hasEntityMatchOption() {
        AbstractContainerMenu abstractContainerMenu = this.player.f_36096_;
        if (abstractContainerMenu instanceof StorageContainerMenuBase) {
            StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)abstractContainerMenu;
            return storageMenu.getEntity().map(entity -> !(entity instanceof Player)).orElse(true);
        }
        return false;
    }
}

