/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.clock;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.block.RotatingBlock;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.ClockBlockEntity;

public class ClockBlock
extends RotatingBlock
implements EntityBlock,
IChimeProvider {
    public static final Supplier<SoundEvent> NO_SOUND = () -> null;
    protected final Supplier<SoundEvent> tickSound;
    protected final Supplier<SoundEvent> chimeSound;
    protected final Supplier<BlockEntityType<ClockBlockEntity>> blockEntitySupplier;

    public ClockBlock(@Nonnull Supplier<SoundEvent> tickSound, @Nonnull Supplier<SoundEvent> chimeSound, VoxelShape shape, @Nonnull Supplier<BlockEntityType<ClockBlockEntity>> blockEntity, BlockBehaviour.Properties pProperties) {
        super(pProperties, RotatingBlock.createShapeBuilder(shape));
        this.tickSound = tickSound;
        this.chimeSound = chimeSound;
        this.blockEntitySupplier = blockEntity;
    }

    @Override
    @Nullable
    public SoundEvent getTickSound(BlockState blockState) {
        return this.tickSound.get();
    }

    @Override
    @Nullable
    public SoundEvent getChimeSound(BlockState blockState) {
        return this.chimeSound.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return this.blockEntitySupplier.get().m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.m_5776_() ? ClockBlockEntity::tick : null;
    }
}

