/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.clock;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.block.RotatingTallBlock;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.ClockBlockEntity;

public class TallClockBlock
extends RotatingTallBlock
implements EntityBlock,
IChimeProvider {
    protected final Supplier<SoundEvent> tickSound;
    protected final Supplier<SoundEvent> chimeSound;
    protected final Supplier<BlockEntityType<ClockBlockEntity>> blockEntitySupplier;

    public TallClockBlock(@Nonnull Supplier<SoundEvent> tickSound, @Nonnull Supplier<SoundEvent> chimeSound, VoxelShape upperShape, VoxelShape lowerShape, @Nonnull Supplier<BlockEntityType<ClockBlockEntity>> blockEntity, BlockBehaviour.Properties pProperties) {
        super(pProperties, RotatingTallBlock.createShapeBuilder(upperShape, lowerShape));
        this.tickSound = tickSound;
        this.chimeSound = chimeSound;
        this.blockEntitySupplier = blockEntity;
    }

    @Override
    @Nullable
    public SoundEvent getTickSound(BlockState blockState) {
        return this.tickSound.get();
    }

    @Override
    @Nullable
    public SoundEvent getChimeSound(BlockState blockState) {
        return this.chimeSound.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (pState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            return this.blockEntitySupplier.get().m_155264_(pPos, pState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.m_5776_() ? ClockBlockEntity::tick : null;
    }
}

