/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingBlock;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.NewtonsCradleBlockEntity;

public class NewtonsCradleBlock
extends RotatingBlock
implements EntityBlock,
IChimeProvider {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    protected final Supplier<SoundEvent> tickSound = TDRegistry.SoundReg.METRONOME_TICK;
    public static final VoxelShape SHAPE = NewtonsCradleBlock.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)8.0, (double)12.0);

    public NewtonsCradleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, RotatingBlock.createShapeBuilder(SHAPE));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{ENABLED}));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_6144_()) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)ENABLED), 3);
            pLevel.m_46717_(pPos, pState.m_60734_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!pLevel.m_5776_() && pFromPos.m_123342_() == pPos.m_123342_() - 1 && (blockEntity = pLevel.m_7702_(pPos)) instanceof NewtonsCradleBlockEntity) {
            NewtonsCradleBlockEntity blockEntity2 = (NewtonsCradleBlockEntity)blockEntity;
            blockEntity2.setSilent(pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_144272_));
        }
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    @Override
    @Nullable
    public SoundEvent getTickSound(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) {
            return this.tickSound.get();
        }
        return null;
    }

    @Override
    public int getTickSoundInterval(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)ENABLED) != false ? 10 : 0;
    }

    @Override
    public float getTickVolume(BlockState blockState, RandomSource random, long dayTime) {
        return 0.125f;
    }

    @Override
    public float getTickPitch(BlockState blockState, RandomSource random, long dayTime) {
        return 1.3f + random.m_188501_() * 0.15f;
    }

    @Override
    public boolean isTimeToChime(BlockState blockState, long dayTime) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)TDRegistry.BlockEntityReg.NEWTONS_CRADLE.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return NewtonsCradleBlockEntity::tick;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ENABLED) != false ? 15 : 0;
    }
}

