/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.client.blockentity.clock.ClockBER;

public class RecognizableClockBER
extends ClockBER {
    public static final ResourceLocation SHORT_HAND = new ResourceLocation("tanukidecor", "block/recognizable_clock/short_hand");
    public static final ResourceLocation LONG_HAND = new ResourceLocation("tanukidecor", "block/recognizable_clock/long_hand");

    public RecognizableClockBER(BlockEntityRendererProvider.Context pContext) {
        super(pContext, SHORT_HAND, LONG_HAND, ROOT_POSITION, ROOT_PIVOT_POINT, HANDS_POSITION, new Vec3(0.5, 0.1875, 0.0));
    }

    @Override
    public void render(ClockBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        BlockState blockState = pBlockEntity.m_58900_();
        Level level = pBlockEntity.m_58904_();
        long dayTime = (level.m_46468_() + 6000L) % 24000L;
        float hourAngleInterval = 0.5235988f;
        float hourRotation = ClockBlockEntity.getHour(dayTime, pPartialTick) * 0.5235988f;
        float minuteRotation = ClockBlockEntity.getMinute(dayTime, 0.98f) * ((float)Math.PI * 2);
        this.clockRenderHelper.withPoseStack(pPoseStack).withBlockState(blockState).withRenderType(pBufferSource, RenderType.m_110463_()).withPackedLight(pPackedLight).withPackedOverlay(pPackedOverlay).withPartialTick(pPartialTick).withRotationZ(0.0f);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            pPoseStack.m_85836_();
            this.clockRenderHelper.withPosition(this.rootPosition).withPivotPoint(this.rootPivotPoint).rotateForDirection(direction);
            this.clockRenderHelper.withModel(mc.m_91304_().getModel(this.shortHand)).withPosition(this.handsPosition).withPivotPoint(this.handsPivotPoint).withRotationZ(hourRotation).render(this.blockRenderer);
            this.clockRenderHelper.withModel(mc.m_91304_().getModel(this.longHand)).withRotationZ(minuteRotation).render(this.blockRenderer);
            this.renderAdditional(this.clockRenderHelper, pBlockEntity, pBufferSource);
            pPoseStack.m_85849_();
        }
    }

    public static void addSpecialModels(Set<ResourceLocation> list) {
        list.add(SHORT_HAND);
        list.add(LONG_HAND);
    }
}

