/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media;

import java.util.HashMap;
import java.util.Map;

public enum VideoProjection {
    RECTANGULAR(0),
    EQUIRECTANGULAR(1),
    CUBEMAP_LAYOUT_STANDARD(256);

    private static final Map<Integer, VideoProjection> INT_MAP;
    private final int intValue;

    public static VideoProjection videoProjection(int intValue) {
        return INT_MAP.get(intValue);
    }

    private VideoProjection(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    static {
        INT_MAP = new HashMap<Integer, VideoProjection>();
        for (VideoProjection projection : VideoProjection.values()) {
            INT_MAP.put(projection.intValue, projection);
        }
    }
}

