/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.base;

import java.util.HashMap;
import java.util.Map;

public enum AudioChannel {
    ERROR(-1),
    UNSET(0),
    STEREO(1),
    RSTEREO(2),
    LEFT(3),
    RIGHT(4),
    DOLBYS(5),
    HEADPHONES(6),
    MONO(7);

    private static final Map<Integer, AudioChannel> INT_MAP;
    private final int intValue;

    public static AudioChannel audioChannel(int intValue) {
        return INT_MAP.get(intValue);
    }

    private AudioChannel(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    static {
        INT_MAP = new HashMap<Integer, AudioChannel>();
        for (AudioChannel value : AudioChannel.values()) {
            INT_MAP.put(value.intValue, value);
        }
    }
}

