/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.typedarrays;

import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.ScriptableObject;
import org.watermedia.shaded.mozilla.javascript.Symbol;
import org.watermedia.shaded.mozilla.javascript.SymbolKey;
import org.watermedia.shaded.mozilla.javascript.Undefined;
import org.watermedia.shaded.mozilla.javascript.typedarrays.NativeArrayBuffer;

public abstract class NativeArrayBufferView
extends ScriptableObject {
    private static final long serialVersionUID = 6884475582973958419L;
    private static Boolean useLittleEndian = null;
    protected final NativeArrayBuffer arrayBuffer;
    protected final int offset;
    protected final int byteLength;

    public NativeArrayBufferView() {
        this.arrayBuffer = new NativeArrayBuffer();
        this.offset = 0;
        this.byteLength = 0;
    }

    protected NativeArrayBufferView(NativeArrayBuffer ab, int offset, int byteLength) {
        this.offset = offset;
        this.byteLength = byteLength;
        this.arrayBuffer = ab;
    }

    public NativeArrayBuffer getBuffer() {
        return this.arrayBuffer;
    }

    public int getByteOffset() {
        return this.offset;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    protected static boolean useLittleEndian() {
        if (useLittleEndian == null) {
            Context ctx = Context.getCurrentContext();
            if (ctx == null) {
                return false;
            }
            useLittleEndian = ctx.hasFeature(19);
        }
        return useLittleEndian;
    }

    protected static boolean isArg(Object[] args, int i) {
        return args.length > i && !Undefined.instance.equals(args[i]);
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        if (SymbolKey.TO_STRING_TAG.equals(key)) {
            return this.getClassName();
        }
        return super.get(key, start);
    }
}

