/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonStringWriter;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.jsoup.Jsoup;
import org.watermedia.shaded.jsoup.nodes.Document;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ReCaptchaException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampCommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.bandcamp.extractors.BandcampExtractorHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;

public class BandcampCommentsExtractor
extends CommentsExtractor {
    private static final String REVIEWS_API_URL = "https://bandcamp.com/api/tralbumcollectors/2/reviews";
    private Document document;

    public BandcampCommentsExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        this.document = Jsoup.parse(downloader.get(this.getLinkHandler().getUrl()).responseBody());
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getInitialPage() throws IOException, ExtractionException {
        CommentsInfoItemsCollector collector = new CommentsInfoItemsCollector(this.getServiceId());
        JsonObject collectorsData = JsonUtils.toJsonObject(this.document.getElementById("collectors-data").attr("data-blob"));
        JsonArray reviews = collectorsData.getArray("reviews");
        for (Object review : reviews) {
            collector.commit(new BandcampCommentsInfoItemExtractor((JsonObject)review, this.getUrl()));
        }
        if (!collectorsData.getBoolean("more_reviews_available")) {
            return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, null);
        }
        String trackId = this.getTrackId();
        String token = this.getNextPageToken(reviews);
        return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, new Page(List.of(trackId, token)));
    }

    @Override
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getPage(Page page) throws IOException, ExtractionException {
        CommentsInfoItemsCollector collector = new CommentsInfoItemsCollector(this.getServiceId());
        List<String> pageIds = page.getIds();
        String trackId = pageIds.get(0);
        String token = pageIds.get(1);
        JsonObject reviewsData = this.fetchReviewsData(trackId, token);
        JsonArray reviews = reviewsData.getArray("results");
        for (Object review : reviews) {
            collector.commit(new BandcampCommentsInfoItemExtractor((JsonObject)review, this.getUrl()));
        }
        if (!reviewsData.getBoolean("more_available")) {
            return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, null);
        }
        return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, new Page(List.of(trackId, this.getNextPageToken(reviews))));
    }

    private JsonObject fetchReviewsData(String trackId, String token) throws ParsingException {
        try {
            return JsonUtils.toJsonObject(this.getDownloader().postWithContentTypeJson(REVIEWS_API_URL, Collections.emptyMap(), ((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)((JsonStringWriter)JsonWriter.string().object()).value("tralbum_type", "t")).value("tralbum_id", trackId)).value("token", token)).value("count", 7)).array("exclude_fan_ids")).end()).end()).done().getBytes(StandardCharsets.UTF_8)).responseBody());
        }
        catch (IOException | ReCaptchaException e) {
            throw new ParsingException("Could not fetch reviews", e);
        }
    }

    private String getNextPageToken(JsonArray reviews) throws ParsingException {
        return reviews.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(review -> review.getString("token")).reduce((a, b) -> b).orElseThrow(() -> new ParsingException("Could not get token"));
    }

    private String getTrackId() throws ParsingException {
        JsonObject pageProperties = JsonUtils.toJsonObject(this.document.selectFirst("meta[name=bc-page-properties]").attr("content"));
        return Long.toString(pageProperties.getLong("item_id"));
    }

    @Override
    public boolean isCommentsDisabled() throws ExtractionException {
        return BandcampExtractorHelper.isRadioUrl(this.getUrl());
    }
}

