/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.extractors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonParser;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.MetaInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.MultiInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.SearchQueryHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.search.SearchExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.peertube.PeertubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class PeertubeSearchExtractor
extends SearchExtractor {
    private final boolean sepia;

    public PeertubeSearchExtractor(StreamingService service, SearchQueryHandler linkHandler) {
        this(service, linkHandler, false);
    }

    public PeertubeSearchExtractor(StreamingService service, SearchQueryHandler linkHandler, boolean sepia) {
        super(service, linkHandler);
        this.sepia = sepia;
    }

    @Override
    @Nonnull
    public String getSearchSuggestion() {
        return "";
    }

    @Override
    public boolean isCorrectedSearch() {
        return false;
    }

    @Override
    @Nonnull
    public List<MetaInfo> getMetaInfo() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<InfoItem> getInitialPage() throws IOException, ExtractionException {
        return this.getPage(new Page(this.getUrl() + "&start=0&count=12"));
    }

    @Override
    public ListExtractor.InfoItemsPage<InfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        Response response = this.getDownloader().get(page.getUrl());
        JsonObject json = null;
        if (response != null && !Utils.isBlank(response.responseBody())) {
            try {
                json = JsonParser.object().from(response.responseBody());
            }
            catch (Exception e) {
                throw new ParsingException("Could not parse json data for search info", e);
            }
        }
        if (json != null) {
            PeertubeParsingHelper.validate(json);
            long total = json.getLong("total");
            MultiInfoItemsCollector collector = new MultiInfoItemsCollector(this.getServiceId());
            PeertubeParsingHelper.collectItemsFrom(collector, json, this.getBaseUrl(), this.sepia);
            return new ListExtractor.InfoItemsPage<InfoItem>(collector, PeertubeParsingHelper.getNextPage(page.getUrl(), total));
        }
        throw new ExtractionException("Unable to get PeerTube search info");
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
    }
}

