/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.soundcloud.SoundcloudParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class SoundcloudChannelInfoItemExtractor
implements ChannelInfoItemExtractor {
    private final JsonObject itemObject;

    public SoundcloudChannelInfoItemExtractor(JsonObject itemObject) {
        this.itemObject = itemObject;
    }

    @Override
    public String getName() {
        return this.itemObject.getString("username");
    }

    @Override
    public String getUrl() {
        return Utils.replaceHttpWithHttps(this.itemObject.getString("permalink_url"));
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() {
        return SoundcloudParsingHelper.getAllImagesFromArtworkOrAvatarUrl(this.itemObject.getString("avatar_url"));
    }

    @Override
    public long getSubscriberCount() {
        return this.itemObject.getLong("followers_count");
    }

    @Override
    public long getStreamCount() {
        return this.itemObject.getLong("track_count");
    }

    @Override
    public boolean isVerified() {
        return this.itemObject.getBoolean("verified");
    }

    @Override
    public String getDescription() {
        return this.itemObject.getString("description", "");
    }
}

