/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubeChannelHelper {
    private static final String BROWSE_ENDPOINT = "browseEndpoint";
    private static final String BROWSE_ID = "browseId";
    private static final String CAROUSEL_HEADER_RENDERER = "carouselHeaderRenderer";
    private static final String C4_TABBED_HEADER_RENDERER = "c4TabbedHeaderRenderer";
    private static final String CONTENT = "content";
    private static final String CONTENTS = "contents";
    private static final String HEADER = "header";
    private static final String PAGE_HEADER_VIEW_MODEL = "pageHeaderViewModel";
    private static final String TAB_RENDERER = "tabRenderer";
    private static final String TITLE = "title";
    private static final String TOPIC_CHANNEL_DETAILS_RENDERER = "topicChannelDetailsRenderer";

    private YoutubeChannelHelper() {
    }

    @Nonnull
    public static String resolveChannelId(@Nonnull String idOrPath) throws ExtractionException, IOException {
        String[] channelId = idOrPath.split("/");
        if (channelId[0].startsWith("UC")) {
            return channelId[0];
        }
        if (!channelId[0].equals("channel")) {
            String urlToResolve = "https://www.youtube.com/" + idOrPath;
            JsonObject endpoint = new JsonObject();
            String webPageType = "";
            for (int tries = 0; urlToResolve != null && tries < 3; ++tries) {
                byte[] body = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(Localization.DEFAULT, ContentCountry.DEFAULT).value("url", urlToResolve)).done()).getBytes(StandardCharsets.UTF_8);
                JsonObject jsonResponse = YoutubeParsingHelper.getJsonPostResponse("navigation/resolve_url", body, Localization.DEFAULT);
                YoutubeChannelHelper.checkIfChannelResponseIsValid(jsonResponse);
                endpoint = jsonResponse.getObject("endpoint");
                webPageType = endpoint.getObject("org.watermedia.shaded.commandMetadata").getObject("webCommandMetadata").getString("webPageType");
                urlToResolve = "WEB_PAGE_TYPE_UNKNOWN".equals(webPageType) ? endpoint.getObject("urlEndpoint").getString("url") : null;
            }
            String browseId = endpoint.getObject(BROWSE_ENDPOINT).getString(BROWSE_ID, "");
            if (("WEB_PAGE_TYPE_BROWSE".equalsIgnoreCase(webPageType) || "WEB_PAGE_TYPE_CHANNEL".equalsIgnoreCase(webPageType)) && !browseId.isEmpty()) {
                if (!browseId.startsWith("UC")) {
                    throw new ExtractionException("Redirected id is not pointing to a channel");
                }
                return browseId;
            }
            if (channelId.length < 2) {
                throw new ExtractionException("Failed to resolve channelId for " + idOrPath);
            }
        }
        return channelId[1];
    }

    @Nonnull
    public static ChannelResponseData getChannelResponse(@Nonnull String channelId, @Nonnull String parameters, @Nonnull Localization localization, @Nonnull ContentCountry country) throws ExtractionException, IOException {
        String id2 = channelId;
        JsonObject ajaxJson = null;
        for (int level = 0; level < 3; ++level) {
            byte[] body = JsonWriter.string(((JsonBuilder)((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, country).value(BROWSE_ID, id2)).value("params", parameters)).done()).getBytes(StandardCharsets.UTF_8);
            JsonObject jsonResponse = YoutubeParsingHelper.getJsonPostResponse("browse", body, localization);
            YoutubeChannelHelper.checkIfChannelResponseIsValid(jsonResponse);
            JsonObject endpoint = jsonResponse.getArray("onResponseReceivedActions").getObject(0).getObject("navigateAction").getObject("endpoint");
            String webPageType = endpoint.getObject("org.watermedia.shaded.commandMetadata").getObject("webCommandMetadata").getString("webPageType");
            String browseId = endpoint.getObject(BROWSE_ENDPOINT).getString(BROWSE_ID, "");
            if (("WEB_PAGE_TYPE_BROWSE".equalsIgnoreCase(webPageType) || "WEB_PAGE_TYPE_CHANNEL".equalsIgnoreCase(webPageType)) && !browseId.isEmpty()) {
                if (!browseId.startsWith("UC")) {
                    throw new ExtractionException("Redirected id is not pointing to a channel");
                }
                id2 = browseId;
                continue;
            }
            ajaxJson = jsonResponse;
            break;
        }
        if (ajaxJson == null) {
            throw new ExtractionException("Got no channel response after 3 redirects");
        }
        YoutubeParsingHelper.defaultAlertsCheck(ajaxJson);
        return new ChannelResponseData(ajaxJson, id2);
    }

    private static void checkIfChannelResponseIsValid(@Nonnull JsonObject jsonResponse) throws ContentNotAvailableException {
        if (!Utils.isNullOrEmpty(jsonResponse.getObject("error"))) {
            JsonObject errorJsonObject = jsonResponse.getObject("error");
            int errorCode = errorJsonObject.getInt("code");
            if (errorCode == 404) {
                throw new ContentNotAvailableException("This channel doesn't exist.");
            }
            throw new ContentNotAvailableException("Got error:\"" + errorJsonObject.getString("status") + "\": " + errorJsonObject.getString("message"));
        }
    }

    @Nullable
    public static ChannelHeader getChannelHeader(@Nonnull JsonObject channelResponse) {
        JsonObject header = channelResponse.getObject(HEADER);
        if (header.has(C4_TABBED_HEADER_RENDERER)) {
            return Optional.of(header.getObject(C4_TABBED_HEADER_RENDERER)).map(json -> new ChannelHeader((JsonObject)json, ChannelHeader.HeaderType.C4_TABBED)).orElse(null);
        }
        if (header.has(CAROUSEL_HEADER_RENDERER)) {
            return header.getObject(CAROUSEL_HEADER_RENDERER).getArray(CONTENTS).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(item -> item.has(TOPIC_CHANNEL_DETAILS_RENDERER)).findFirst().map(item -> item.getObject(TOPIC_CHANNEL_DETAILS_RENDERER)).map(json -> new ChannelHeader((JsonObject)json, ChannelHeader.HeaderType.CAROUSEL)).orElse(null);
        }
        if (header.has("pageHeaderRenderer")) {
            return Optional.of(header.getObject("pageHeaderRenderer")).map(json -> new ChannelHeader((JsonObject)json, ChannelHeader.HeaderType.PAGE)).orElse(null);
        }
        if (header.has("interactiveTabbedHeaderRenderer")) {
            return Optional.of(header.getObject("interactiveTabbedHeaderRenderer")).map(json -> new ChannelHeader((JsonObject)json, ChannelHeader.HeaderType.INTERACTIVE_TABBED)).orElse(null);
        }
        return null;
    }

    public static boolean isChannelVerified(@Nonnull ChannelHeader channelHeader) {
        switch (channelHeader.headerType) {
            case CAROUSEL: {
                return true;
            }
            case PAGE: {
                JsonObject pageHeaderViewModel = channelHeader.json.getObject(CONTENT).getObject(PAGE_HEADER_VIEW_MODEL);
                boolean hasCircleOrMusicIcon = YoutubeParsingHelper.hasArtistOrVerifiedIconBadgeAttachment(pageHeaderViewModel.getObject(TITLE).getObject("dynamicTextViewModel").getObject("text").getArray("attachmentRuns"));
                if (!hasCircleOrMusicIcon && pageHeaderViewModel.getObject("image").has("contentPreviewImageViewModel")) {
                    return true;
                }
                return hasCircleOrMusicIcon;
            }
            case INTERACTIVE_TABBED: {
                return channelHeader.json.has("autoGenerated");
            }
        }
        return YoutubeParsingHelper.isVerified(channelHeader.json.getArray("badges"));
    }

    @Nonnull
    public static String getChannelId(@Nullable ChannelHeader channelHeader, @Nonnull JsonObject jsonResponse, @Nullable String fallbackChannelId) throws ParsingException {
        String externalChannelId;
        if (channelHeader != null) {
            switch (channelHeader.headerType) {
                case C4_TABBED: {
                    String channelId = channelHeader.json.getObject(HEADER).getObject(C4_TABBED_HEADER_RENDERER).getString("channelId", "");
                    if (!Utils.isNullOrEmpty(channelId)) {
                        return channelId;
                    }
                    String navigationC4TabChannelId = channelHeader.json.getObject("navigationEndpoint").getObject(BROWSE_ENDPOINT).getString(BROWSE_ID);
                    if (Utils.isNullOrEmpty(navigationC4TabChannelId)) break;
                    return navigationC4TabChannelId;
                }
                case CAROUSEL: {
                    String navigationCarouselChannelId = channelHeader.json.getObject(HEADER).getObject(CAROUSEL_HEADER_RENDERER).getArray(CONTENTS).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(item -> item.has(TOPIC_CHANNEL_DETAILS_RENDERER)).findFirst().orElse(new JsonObject()).getObject(TOPIC_CHANNEL_DETAILS_RENDERER).getObject("navigationEndpoint").getObject(BROWSE_ENDPOINT).getString(BROWSE_ID);
                    if (Utils.isNullOrEmpty(navigationCarouselChannelId)) break;
                    return navigationCarouselChannelId;
                }
            }
        }
        if (!Utils.isNullOrEmpty(externalChannelId = jsonResponse.getObject("metadata").getObject("channelMetadataRenderer").getString("externalChannelId"))) {
            return externalChannelId;
        }
        if (!Utils.isNullOrEmpty(fallbackChannelId)) {
            return fallbackChannelId;
        }
        throw new ParsingException("Could not get channel ID");
    }

    @Nonnull
    public static String getChannelName(@Nullable ChannelHeader channelHeader, @Nullable JsonObject channelAgeGateRenderer, @Nonnull JsonObject jsonResponse) throws ParsingException {
        if (channelAgeGateRenderer != null) {
            String title = channelAgeGateRenderer.getString("channelTitle");
            if (Utils.isNullOrEmpty(title)) {
                throw new ParsingException("Could not get channel name");
            }
            return title;
        }
        String metadataRendererTitle = jsonResponse.getObject("metadata").getObject("channelMetadataRenderer").getString(TITLE);
        if (!Utils.isNullOrEmpty(metadataRendererTitle)) {
            return metadataRendererTitle;
        }
        return Optional.ofNullable(channelHeader).map(header -> {
            JsonObject channelJson = header.json;
            switch (header.headerType) {
                case PAGE: {
                    return channelJson.getObject(CONTENT).getObject(PAGE_HEADER_VIEW_MODEL).getObject(TITLE).getObject("dynamicTextViewModel").getObject("text").getString(CONTENT, channelJson.getString("pageTitle"));
                }
                case CAROUSEL: 
                case INTERACTIVE_TABBED: {
                    return YoutubeParsingHelper.getTextFromObject(channelJson.getObject(TITLE));
                }
            }
            return channelJson.getString(TITLE);
        }).or(() -> Optional.ofNullable(jsonResponse.getObject("microformat").getObject("microformatDataRenderer").getString(TITLE))).orElseThrow(() -> new ParsingException("Could not get channel name"));
    }

    @Nullable
    public static JsonObject getChannelAgeGateRenderer(@Nonnull JsonObject jsonResponse) {
        return jsonResponse.getObject(CONTENTS).getObject("twoColumnBrowseResultsRenderer").getArray("tabs").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).flatMap(tab -> tab.getObject(TAB_RENDERER).getObject(CONTENT).getObject("sectionListRenderer").getArray(CONTENTS).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast)).filter(content -> content.has("channelAgeGateRenderer")).map(content -> content.getObject("channelAgeGateRenderer")).findFirst().orElse(null);
    }

    public static final class ChannelHeader
    implements Serializable {
        @Nonnull
        public final JsonObject json;
        public final HeaderType headerType;

        public ChannelHeader(@Nonnull JsonObject json, HeaderType headerType) {
            this.json = json;
            this.headerType = headerType;
        }

        public static enum HeaderType {
            C4_TABBED,
            INTERACTIVE_TABBED,
            CAROUSEL,
            PAGE;

        }
    }

    public static final class ChannelResponseData {
        @Nonnull
        public final JsonObject jsonResponse;
        @Nonnull
        public final String channelId;

        private ChannelResponseData(@Nonnull JsonObject jsonResponse, @Nonnull String channelId) {
            this.jsonResponse = jsonResponse;
            this.channelId = channelId;
        }
    }
}

