/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.DeliveryType;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.ItagItem;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators.CreationException;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.dashmanifestcreators.YoutubeDashManifestCreatorsUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ManifestCreatorCache;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public final class YoutubePostLiveStreamDvrDashManifestCreator {
    private static final ManifestCreatorCache<String, String> POST_LIVE_DVR_STREAMS_CACHE = new ManifestCreatorCache();

    private YoutubePostLiveStreamDvrDashManifestCreator() {
    }

    @Nonnull
    public static String fromPostLiveStreamDvrStreamingUrl(@Nonnull String postLiveStreamDvrStreamingUrl, @Nonnull ItagItem itagItem, int targetDurationSec, long durationSecondsFallback) throws CreationException {
        long streamDuration;
        String segmentCount;
        String streamDurationString;
        if (POST_LIVE_DVR_STREAMS_CACHE.containsKey(postLiveStreamDvrStreamingUrl)) {
            return Objects.requireNonNull(POST_LIVE_DVR_STREAMS_CACHE.get(postLiveStreamDvrStreamingUrl)).getSecond();
        }
        String realPostLiveStreamDvrStreamingUrl = postLiveStreamDvrStreamingUrl;
        if (targetDurationSec <= 0) {
            throw new CreationException("targetDurationSec value is <= 0: " + targetDurationSec);
        }
        try {
            Response response = YoutubeDashManifestCreatorsUtils.getInitializationResponse(realPostLiveStreamDvrStreamingUrl, itagItem, DeliveryType.LIVE);
            realPostLiveStreamDvrStreamingUrl = response.latestUrl().replace("&sq=0", "").replace("&rn=0", "").replace("&alr=yes", "");
            int responseCode = response.responseCode();
            if (responseCode != 200) {
                throw new CreationException("Could not get the initialization sequence: response code " + responseCode);
            }
            Map<String, List<String>> responseHeaders = response.responseHeaders();
            streamDurationString = responseHeaders.get("X-Head-Time-Millis").get(0);
            segmentCount = responseHeaders.get("X-Head-Seqnum").get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CreationException("Could not get the value of the X-Head-Time-Millis or the X-Head-Seqnum header", e);
        }
        if (Utils.isNullOrEmpty(segmentCount)) {
            throw new CreationException("Could not get the number of segments");
        }
        try {
            streamDuration = Long.parseLong(streamDurationString);
        }
        catch (NumberFormatException e) {
            streamDuration = durationSecondsFallback;
        }
        Document doc = YoutubeDashManifestCreatorsUtils.generateDocumentAndDoCommonElementsGeneration(itagItem, streamDuration);
        YoutubeDashManifestCreatorsUtils.generateSegmentTemplateElement(doc, realPostLiveStreamDvrStreamingUrl, DeliveryType.LIVE);
        YoutubeDashManifestCreatorsUtils.generateSegmentTimelineElement(doc);
        YoutubePostLiveStreamDvrDashManifestCreator.generateSegmentElementForPostLiveDvrStreams(doc, targetDurationSec, segmentCount);
        return YoutubeDashManifestCreatorsUtils.buildAndCacheResult(postLiveStreamDvrStreamingUrl, doc, POST_LIVE_DVR_STREAMS_CACHE);
    }

    @Nonnull
    public static ManifestCreatorCache<String, String> getCache() {
        return POST_LIVE_DVR_STREAMS_CACHE;
    }

    private static void generateSegmentElementForPostLiveDvrStreams(@Nonnull Document doc, int targetDurationSeconds, @Nonnull String segmentCount) throws CreationException {
        try {
            Element segmentTimelineElement = (Element)doc.getElementsByTagName("SegmentTimeline").item(0);
            Element sElement = doc.createElement("S");
            YoutubeDashManifestCreatorsUtils.setAttribute(sElement, doc, "d", String.valueOf(targetDurationSeconds * 1000));
            YoutubeDashManifestCreatorsUtils.setAttribute(sElement, doc, "r", segmentCount);
            segmentTimelineElement.appendChild(sElement);
        }
        catch (DOMException e) {
            throw CreationException.couldNotAddElement("segment (S)", e);
        }
    }
}

