/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.channel.ChannelExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ReadyChannelTabListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeChannelHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeChannelTabExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeChannelTabPlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubeChannelTabLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeChannelExtractor
extends ChannelExtractor {
    private static final String IMAGE = "image";
    private static final String CONTENTS = "contents";
    private static final String CONTENT_PREVIEW_IMAGE_VIEW_MODEL = "contentPreviewImageViewModel";
    private static final String PAGE_HEADER_VIEW_MODEL = "pageHeaderViewModel";
    private static final String TAB_RENDERER = "tabRenderer";
    private static final String CONTENT = "content";
    private static final String METADATA = "metadata";
    private static final String AVATAR = "avatar";
    private static final String THUMBNAILS = "thumbnails";
    private static final String SOURCES = "sources";
    private static final String BANNER = "banner";
    private JsonObject jsonResponse;
    @Nullable
    private YoutubeChannelHelper.ChannelHeader channelHeader;
    private String channelId;
    @Nullable
    private JsonObject channelAgeGateRenderer;

    public YoutubeChannelExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String channelPath = super.getId();
        String id2 = YoutubeChannelHelper.resolveChannelId(channelPath);
        YoutubeChannelHelper.ChannelResponseData data = YoutubeChannelHelper.getChannelResponse(id2, "EgZ2aWRlb3PyBgQKAjoA", this.getExtractorLocalization(), this.getExtractorContentCountry());
        this.jsonResponse = data.jsonResponse;
        this.channelHeader = YoutubeChannelHelper.getChannelHeader(this.jsonResponse);
        this.channelId = data.channelId;
        this.channelAgeGateRenderer = YoutubeChannelHelper.getChannelAgeGateRenderer(this.jsonResponse);
    }

    @Override
    @Nonnull
    public String getUrl() throws ParsingException {
        try {
            return YoutubeChannelLinkHandlerFactory.getInstance().getUrl("channel/" + this.getId());
        }
        catch (ParsingException e) {
            return super.getUrl();
        }
    }

    @Override
    @Nonnull
    public String getId() throws ParsingException {
        this.assertPageFetched();
        return YoutubeChannelHelper.getChannelId(this.channelHeader, this.jsonResponse, this.channelId);
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        this.assertPageFetched();
        return YoutubeChannelHelper.getChannelName(this.channelHeader, this.channelAgeGateRenderer, this.jsonResponse);
    }

    @Override
    @Nonnull
    public List<Image> getAvatars() throws ParsingException {
        this.assertPageFetched();
        if (this.channelAgeGateRenderer != null) {
            return Optional.ofNullable(this.channelAgeGateRenderer.getObject(AVATAR).getArray(THUMBNAILS)).map(YoutubeParsingHelper::getImagesFromThumbnailsArray).orElseThrow(() -> new ParsingException("Could not get avatars"));
        }
        return Optional.ofNullable(this.channelHeader).map(header -> {
            switch (header.headerType) {
                case PAGE: {
                    JsonObject imageObj = header.json.getObject(CONTENT).getObject(PAGE_HEADER_VIEW_MODEL).getObject(IMAGE);
                    if (imageObj.has(CONTENT_PREVIEW_IMAGE_VIEW_MODEL)) {
                        return imageObj.getObject(CONTENT_PREVIEW_IMAGE_VIEW_MODEL).getObject(IMAGE).getArray(SOURCES);
                    }
                    if (imageObj.has("decoratedAvatarViewModel")) {
                        return imageObj.getObject("decoratedAvatarViewModel").getObject(AVATAR).getObject("avatarViewModel").getObject(IMAGE).getArray(SOURCES);
                    }
                    return new JsonArray();
                }
                case INTERACTIVE_TABBED: {
                    return header.json.getObject("boxArt").getArray(THUMBNAILS);
                }
            }
            return header.json.getObject(AVATAR).getArray(THUMBNAILS);
        }).map(YoutubeParsingHelper::getImagesFromThumbnailsArray).orElseThrow(() -> new ParsingException("Could not get avatars"));
    }

    @Override
    @Nonnull
    public List<Image> getBanners() {
        this.assertPageFetched();
        if (this.channelAgeGateRenderer != null) {
            return List.of();
        }
        return Optional.ofNullable(this.channelHeader).map(header -> {
            if (header.headerType == YoutubeChannelHelper.ChannelHeader.HeaderType.PAGE) {
                JsonObject pageHeaderViewModel = header.json.getObject(CONTENT).getObject(PAGE_HEADER_VIEW_MODEL);
                if (pageHeaderViewModel.has(BANNER)) {
                    return pageHeaderViewModel.getObject(BANNER).getObject("imageBannerViewModel").getObject(IMAGE).getArray(SOURCES);
                }
                return new JsonArray();
            }
            return header.json.getObject(BANNER).getArray(THUMBNAILS);
        }).map(YoutubeParsingHelper::getImagesFromThumbnailsArray).orElse(List.of());
    }

    @Override
    public String getFeedUrl() throws ParsingException {
        try {
            return YoutubeParsingHelper.getFeedUrlFrom(this.getId());
        }
        catch (Exception e) {
            throw new ParsingException("Could not get feed URL", e);
        }
    }

    @Override
    public long getSubscriberCount() throws ParsingException {
        this.assertPageFetched();
        if (this.channelAgeGateRenderer != null) {
            return -1L;
        }
        if (this.channelHeader != null) {
            if (this.channelHeader.headerType == YoutubeChannelHelper.ChannelHeader.HeaderType.INTERACTIVE_TABBED) {
                return -1L;
            }
            JsonObject headerJson = this.channelHeader.json;
            if (this.channelHeader.headerType == YoutubeChannelHelper.ChannelHeader.HeaderType.PAGE) {
                return this.getSubscriberCountFromPageChannelHeader(headerJson);
            }
            JsonObject textObject = null;
            if (headerJson.has("subscriberCountText")) {
                textObject = headerJson.getObject("subscriberCountText");
            } else if (headerJson.has("subtitle")) {
                textObject = headerJson.getObject("subtitle");
            }
            if (textObject != null) {
                try {
                    return Utils.mixedNumberWordToLong(YoutubeParsingHelper.getTextFromObject(textObject));
                }
                catch (NumberFormatException e) {
                    throw new ParsingException("Could not get subscriber count", e);
                }
            }
        }
        return -1L;
    }

    private long getSubscriberCountFromPageChannelHeader(@Nonnull JsonObject headerJson) throws ParsingException {
        JsonObject metadataObject = headerJson.getObject(CONTENT).getObject(PAGE_HEADER_VIEW_MODEL).getObject(METADATA);
        if (metadataObject.has("contentMetadataViewModel")) {
            JsonArray metadataRows = metadataObject.getObject("contentMetadataViewModel").getArray("metadataRows");
            JsonArray lastMetadataRowParts = metadataRows.getObject(Math.max(0, metadataRows.size() - 1)).getArray("metadataParts");
            if (lastMetadataRowParts.size() < 2) {
                return -1L;
            }
            try {
                return Utils.mixedNumberWordToLong(lastMetadataRowParts.getObject(0).getObject("text").getString(CONTENT));
            }
            catch (NumberFormatException e) {
                throw new ParsingException("Could not get subscriber count", e);
            }
        }
        return -1L;
    }

    @Override
    public String getDescription() throws ParsingException {
        this.assertPageFetched();
        if (this.channelAgeGateRenderer != null) {
            return null;
        }
        try {
            if (this.channelHeader != null && this.channelHeader.headerType == YoutubeChannelHelper.ChannelHeader.HeaderType.INTERACTIVE_TABBED) {
                return YoutubeParsingHelper.getTextFromObject(this.channelHeader.json.getObject("description"));
            }
            return this.jsonResponse.getObject(METADATA).getObject("channelMetadataRenderer").getString("description");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get channel description", e);
        }
    }

    @Override
    public String getParentChannelName() {
        return "";
    }

    @Override
    public String getParentChannelUrl() {
        return "";
    }

    @Override
    @Nonnull
    public List<Image> getParentChannelAvatars() {
        return List.of();
    }

    @Override
    public boolean isVerified() throws ParsingException {
        this.assertPageFetched();
        if (this.channelAgeGateRenderer != null) {
            return false;
        }
        if (this.channelHeader == null) {
            throw new ParsingException("Could not get channel verified status, no channel header has been extracted");
        }
        return YoutubeChannelHelper.isChannelVerified(this.channelHeader);
    }

    @Override
    @Nonnull
    public List<ListLinkHandler> getTabs() throws ParsingException {
        this.assertPageFetched();
        if (this.channelAgeGateRenderer == null) {
            return this.getTabsForNonAgeRestrictedChannels();
        }
        return this.getTabsForAgeRestrictedChannels();
    }

    @Nonnull
    private List<ListLinkHandler> getTabsForNonAgeRestrictedChannels() throws ParsingException {
        JsonArray responseTabs = this.jsonResponse.getObject(CONTENTS).getObject("twoColumnBrowseResultsRenderer").getArray("tabs");
        ArrayList tabs = new ArrayList();
        Consumer<String> addNonVideosTab = tabName -> {
            try {
                tabs.add(YoutubeChannelTabLinkHandlerFactory.getInstance().fromQuery(this.channelId, List.of(tabName), ""));
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        };
        String name = this.getName();
        String url = this.getUrl();
        String id2 = this.getId();
        responseTabs.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(tab -> tab.has(TAB_RENDERER)).map(tab -> tab.getObject(TAB_RENDERER)).forEach(tabRenderer -> {
            String tabUrl = tabRenderer.getObject("endpoint").getObject("org.watermedia.shaded.commandMetadata").getObject("webCommandMetadata").getString("url");
            if (tabUrl != null) {
                String[] urlParts = tabUrl.split("/");
                if (urlParts.length == 0) {
                    return;
                }
                String urlSuffix = urlParts[urlParts.length - 1];
                YoutubeChannelHelper.ChannelHeader channelHeaderCopy = this.channelHeader == null ? null : new YoutubeChannelHelper.ChannelHeader(this.channelHeader.json, this.channelHeader.headerType);
                switch (urlSuffix) {
                    case "videos": {
                        tabs.add(0, new ReadyChannelTabListLinkHandler(tabUrl, this.channelId, "videos", (service, linkHandler) -> new YoutubeChannelTabExtractor.VideosTabExtractor(service, linkHandler, (JsonObject)tabRenderer, channelHeaderCopy, name, id2, url)));
                        break;
                    }
                    case "shorts": {
                        addNonVideosTab.accept("shorts");
                        break;
                    }
                    case "streams": {
                        addNonVideosTab.accept("livestreams");
                        break;
                    }
                    case "releases": {
                        addNonVideosTab.accept("albums");
                        break;
                    }
                    case "playlists": {
                        addNonVideosTab.accept("playlists");
                        break;
                    }
                }
            }
        });
        return Collections.unmodifiableList(tabs);
    }

    @Nonnull
    private List<ListLinkHandler> getTabsForAgeRestrictedChannels() throws ParsingException {
        ArrayList tabs = new ArrayList();
        String channelUrl = this.getUrl();
        Consumer<String> addTab = tabName -> tabs.add(new ReadyChannelTabListLinkHandler(channelUrl + "/" + tabName, this.channelId, (String)tabName, YoutubeChannelTabPlaylistExtractor::new));
        addTab.accept("videos");
        addTab.accept("shorts");
        addTab.accept("livestreams");
        return Collections.unmodifiableList(tabs);
    }

    @Override
    @Nonnull
    public List<String> getTags() throws ParsingException {
        this.assertPageFetched();
        if (this.channelAgeGateRenderer != null) {
            return List.of();
        }
        return this.jsonResponse.getObject("microformat").getObject("microformatDataRenderer").getArray("tags").stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toUnmodifiableList());
    }
}

