/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeCommentsEUVMInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeCommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeCommentsExtractor
extends CommentsExtractor {
    private static final String COMMENT_VIEW_MODEL_KEY = "org.watermedia.shaded.commentViewModel";
    private static final String COMMENT_RENDERER_KEY = "org.watermedia.shaded.commentRenderer";
    private boolean commentsDisabled;
    private JsonObject ajaxJson;

    public YoutubeCommentsExtractor(StreamingService service, ListLinkHandler uiHandler) {
        super(service, uiHandler);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getInitialPage() throws IOException, ExtractionException {
        if (this.commentsDisabled) {
            return this.getInfoItemsPageForDisabledComments();
        }
        return this.extractComments(this.ajaxJson);
    }

    @Nullable
    private String findInitialCommentsToken(JsonObject nextResponse) {
        JsonArray contents = this.getJsonContents(nextResponse);
        if (contents == null) {
            return null;
        }
        String token = contents.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(jObj -> {
            try {
                return "org.watermedia.shaded.comments-section".equals(JsonUtils.getString(jObj, "itemSectionRenderer.targetId"));
            }
            catch (ParsingException ignored) {
                return false;
            }
        }).findFirst().map(itemSectionRenderer -> {
            try {
                return JsonUtils.getString(itemSectionRenderer.getObject("itemSectionRenderer").getArray("contents").getObject(0), "continuationItemRenderer.continuationEndpoint.continuationCommand.token");
            }
            catch (ParsingException ignored) {
                return null;
            }
        }).orElse(null);
        this.commentsDisabled = token == null;
        return token;
    }

    @Nullable
    private JsonArray getJsonContents(JsonObject nextResponse) {
        try {
            return JsonUtils.getArray(nextResponse, "contents.twoColumnWatchNextResults.results.results.contents");
        }
        catch (ParsingException e) {
            return null;
        }
    }

    @Nonnull
    private JsonObject getMutationPayloadFromEntityKey(@Nonnull JsonArray mutations, @Nonnull String commentKey) throws ParsingException {
        return mutations.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(mutation -> commentKey.equals(mutation.getString("entityKey"))).findFirst().orElseThrow(() -> new ParsingException("Could not get comment entity payload mutation")).getObject("payload");
    }

    @Nonnull
    private ListExtractor.InfoItemsPage<CommentsInfoItem> getInfoItemsPageForDisabledComments() {
        return new ListExtractor.InfoItemsPage<CommentsInfoItem>(Collections.emptyList(), null, Collections.emptyList());
    }

    @Nullable
    private Page getNextPage(@Nonnull JsonObject jsonObject) throws ExtractionException {
        String continuation;
        JsonArray continuationItemsArray;
        JsonArray onResponseReceivedEndpoints = jsonObject.getArray("onResponseReceivedEndpoints");
        if (onResponseReceivedEndpoints.isEmpty()) {
            return null;
        }
        try {
            JsonObject endpoint = onResponseReceivedEndpoints.getObject(onResponseReceivedEndpoints.size() - 1);
            continuationItemsArray = endpoint.getObject("reloadContinuationItemsCommand", endpoint.getObject("appendContinuationItemsAction")).getArray("continuationItems");
        }
        catch (Exception e) {
            return null;
        }
        if (continuationItemsArray.isEmpty()) {
            return null;
        }
        JsonObject continuationItemRenderer = continuationItemsArray.getObject(continuationItemsArray.size() - 1).getObject("continuationItemRenderer");
        String jsonPath = continuationItemRenderer.has("button") ? "button.buttonRenderer.command.continuationCommand.token" : "continuationEndpoint.continuationCommand.token";
        try {
            continuation = JsonUtils.getString(continuationItemRenderer, jsonPath);
        }
        catch (Exception e) {
            return null;
        }
        return this.getNextPage(continuation);
    }

    @Nonnull
    private Page getNextPage(String continuation) throws ParsingException {
        return new Page(this.getUrl(), continuation);
    }

    @Override
    public ListExtractor.InfoItemsPage<CommentsInfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (this.commentsDisabled) {
            return this.getInfoItemsPageForDisabledComments();
        }
        if (page == null || Utils.isNullOrEmpty(page.getId())) {
            throw new IllegalArgumentException("Page doesn't have the continuation.");
        }
        Localization localization = this.getExtractorLocalization();
        byte[] body = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("continuation", page.getId())).done()).getBytes(StandardCharsets.UTF_8);
        JsonObject jsonObject = YoutubeParsingHelper.getJsonPostResponse("next", body, localization);
        return this.extractComments(jsonObject);
    }

    private ListExtractor.InfoItemsPage<CommentsInfoItem> extractComments(JsonObject jsonObject) throws ExtractionException {
        CommentsInfoItemsCollector collector = new CommentsInfoItemsCollector(this.getServiceId());
        this.collectCommentsFrom(collector, jsonObject);
        return new ListExtractor.InfoItemsPage<CommentsInfoItem>(collector, this.getNextPage(jsonObject));
    }

    private void collectCommentsFrom(@Nonnull CommentsInfoItemsCollector collector, @Nonnull JsonObject jsonObject) throws ParsingException {
        JsonArray contents;
        String path;
        JsonArray onResponseReceivedEndpoints = jsonObject.getArray("onResponseReceivedEndpoints");
        if (onResponseReceivedEndpoints.isEmpty()) {
            return;
        }
        JsonObject commentsEndpoint = onResponseReceivedEndpoints.getObject(onResponseReceivedEndpoints.size() - 1);
        if (commentsEndpoint.has("reloadContinuationItemsCommand")) {
            path = "reloadContinuationItemsCommand.continuationItems";
        } else if (commentsEndpoint.has("appendContinuationItemsAction")) {
            path = "appendContinuationItemsAction.continuationItems";
        } else {
            return;
        }
        try {
            contents = new JsonArray((Collection<?>)JsonUtils.getArray(commentsEndpoint, path));
        }
        catch (Exception e) {
            return;
        }
        int index = contents.size() - 1;
        if (!contents.isEmpty() && contents.getObject(index).has("continuationItemRenderer")) {
            contents.remove(index);
        }
        JsonArray mutations = jsonObject.getObject("frameworkUpdates").getObject("entityBatchUpdate").getArray("mutations");
        String videoUrl = this.getUrl();
        TimeAgoParser timeAgoParser = this.getTimeAgoParser();
        for (Object o : contents) {
            if (!(o instanceof JsonObject)) continue;
            this.collectCommentItem(mutations, (JsonObject)o, collector, videoUrl, timeAgoParser);
        }
    }

    private void collectCommentItem(@Nonnull JsonArray mutations, @Nonnull JsonObject content, @Nonnull CommentsInfoItemsCollector collector, @Nonnull String videoUrl, @Nonnull TimeAgoParser timeAgoParser) throws ParsingException {
        if (content.has("org.watermedia.shaded.commentThreadRenderer")) {
            JsonObject commentThreadRenderer = content.getObject("org.watermedia.shaded.commentThreadRenderer");
            if (commentThreadRenderer.has(COMMENT_VIEW_MODEL_KEY)) {
                JsonObject commentViewModel = commentThreadRenderer.getObject(COMMENT_VIEW_MODEL_KEY).getObject(COMMENT_VIEW_MODEL_KEY);
                collector.commit(new YoutubeCommentsEUVMInfoItemExtractor(commentViewModel, commentThreadRenderer.getObject("replies").getObject("org.watermedia.shaded.commentRepliesRenderer"), this.getMutationPayloadFromEntityKey(mutations, commentViewModel.getString("org.watermedia.shaded.commentKey", "")).getObject("org.watermedia.shaded.commentEntityPayload"), this.getMutationPayloadFromEntityKey(mutations, commentViewModel.getString("toolbarStateKey", "")).getObject("engagementToolbarStateEntityPayload"), videoUrl, timeAgoParser));
            } else if (commentThreadRenderer.has("org.watermedia.shaded.comment")) {
                collector.commit(new YoutubeCommentsInfoItemExtractor(commentThreadRenderer.getObject("org.watermedia.shaded.comment").getObject(COMMENT_RENDERER_KEY), commentThreadRenderer.getObject("replies").getObject("org.watermedia.shaded.commentRepliesRenderer"), videoUrl, timeAgoParser));
            }
        } else if (content.has(COMMENT_VIEW_MODEL_KEY)) {
            JsonObject commentViewModel = content.getObject(COMMENT_VIEW_MODEL_KEY);
            collector.commit(new YoutubeCommentsEUVMInfoItemExtractor(commentViewModel, null, this.getMutationPayloadFromEntityKey(mutations, commentViewModel.getString("org.watermedia.shaded.commentKey", "")).getObject("org.watermedia.shaded.commentEntityPayload"), this.getMutationPayloadFromEntityKey(mutations, commentViewModel.getString("toolbarStateKey", "")).getObject("engagementToolbarStateEntityPayload"), videoUrl, timeAgoParser));
        } else if (content.has(COMMENT_RENDERER_KEY)) {
            collector.commit(new YoutubeCommentsInfoItemExtractor(content.getObject(COMMENT_RENDERER_KEY), null, videoUrl, timeAgoParser));
        }
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Localization localization = this.getExtractorLocalization();
        byte[] body = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("videoId", this.getId())).done()).getBytes(StandardCharsets.UTF_8);
        String initialToken = this.findInitialCommentsToken(YoutubeParsingHelper.getJsonPostResponse("next", body, localization));
        if (initialToken == null) {
            return;
        }
        byte[] ajaxBody = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("continuation", initialToken)).done()).getBytes(StandardCharsets.UTF_8);
        this.ajaxJson = YoutubeParsingHelper.getJsonPostResponse("next", ajaxBody, localization);
    }

    @Override
    public boolean isCommentsDisabled() {
        return this.commentsDisabled;
    }

    @Override
    public int getCommentsCount() throws ExtractionException {
        this.assertPageFetched();
        if (this.commentsDisabled) {
            return -1;
        }
        JsonObject countText = this.ajaxJson.getArray("onResponseReceivedEndpoints").getObject(0).getObject("reloadContinuationItemsCommand").getArray("continuationItems").getObject(0).getObject("org.watermedia.shaded.commentsHeaderRenderer").getObject("countText");
        try {
            return Integer.parseInt(Utils.removeNonDigitCharacters(YoutubeParsingHelper.getTextFromObject(countText)));
        }
        catch (Exception e) {
            throw new ExtractionException("Unable to get comments count", e);
        }
    }
}

