/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.DateWrapper;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeCommentsInfoItemExtractor
implements CommentsInfoItemExtractor {
    @Nonnull
    private final JsonObject commentRenderer;
    @Nullable
    private final JsonObject commentRepliesRenderer;
    @Nonnull
    private final String url;
    @Nonnull
    private final TimeAgoParser timeAgoParser;

    public YoutubeCommentsInfoItemExtractor(@Nonnull JsonObject commentRenderer, @Nullable JsonObject commentRepliesRenderer, @Nonnull String url, @Nonnull TimeAgoParser timeAgoParser) {
        this.commentRenderer = commentRenderer;
        this.commentRepliesRenderer = commentRepliesRenderer;
        this.url = url;
        this.timeAgoParser = timeAgoParser;
    }

    @Nonnull
    private List<Image> getAuthorThumbnails() throws ParsingException {
        try {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(JsonUtils.getArray(this.commentRenderer, "authorThumbnail.thumbnails"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get author thumbnails", e);
        }
    }

    @Override
    @Nonnull
    public String getUrl() throws ParsingException {
        return this.url;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        return this.getAuthorThumbnails();
    }

    @Override
    public String getName() throws ParsingException {
        try {
            return YoutubeParsingHelper.getTextFromObject(JsonUtils.getObject(this.commentRenderer, "authorText"));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getTextualUploadDate() throws ParsingException {
        try {
            return YoutubeParsingHelper.getTextFromObject(JsonUtils.getObject(this.commentRenderer, "publishedTimeText"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get publishedTimeText", e);
        }
    }

    @Override
    @Nullable
    public DateWrapper getUploadDate() throws ParsingException {
        String textualPublishedTime = this.getTextualUploadDate();
        if (textualPublishedTime != null && !textualPublishedTime.isEmpty()) {
            return this.timeAgoParser.parse(textualPublishedTime);
        }
        return null;
    }

    @Override
    public int getLikeCount() throws ParsingException {
        String likeCount;
        try {
            likeCount = Utils.removeNonDigitCharacters(JsonUtils.getString(this.commentRenderer, "actionButtons.commentActionButtonsRenderer.likeButton.toggleButtonRenderer.accessibilityData.accessibilityData.label"));
        }
        catch (Exception e) {
            String textualLikeCount = this.getTextualLikeCount();
            try {
                if (Utils.isBlank(textualLikeCount)) {
                    return 0;
                }
                return (int)Utils.mixedNumberWordToLong(textualLikeCount);
            }
            catch (Exception i) {
                throw new ParsingException("Unexpected error while converting textual like count to like count", i);
            }
        }
        try {
            if (Utils.isBlank(likeCount)) {
                return 0;
            }
            return Integer.parseInt(likeCount);
        }
        catch (Exception e) {
            throw new ParsingException("Unexpected error while parsing like count as Integer", e);
        }
    }

    @Override
    public String getTextualLikeCount() throws ParsingException {
        try {
            if (!this.commentRenderer.has("voteCount")) {
                return "";
            }
            JsonObject voteCountObj = JsonUtils.getObject(this.commentRenderer, "voteCount");
            if (voteCountObj.isEmpty()) {
                return "";
            }
            return YoutubeParsingHelper.getTextFromObject(voteCountObj);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get the vote count", e);
        }
    }

    @Override
    @Nonnull
    public Description getCommentText() throws ParsingException {
        try {
            JsonObject contentText = JsonUtils.getObject(this.commentRenderer, "contentText");
            if (contentText.isEmpty()) {
                return Description.EMPTY_DESCRIPTION;
            }
            String commentText = YoutubeParsingHelper.getTextFromObject(contentText, true);
            String commentTextBomRemoved = Utils.removeUTF8BOM(commentText);
            return new Description(commentTextBomRemoved, 1);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get comment text", e);
        }
    }

    @Override
    public String getCommentId() throws ParsingException {
        try {
            return JsonUtils.getString(this.commentRenderer, "org.watermedia.shaded.commentId");
        }
        catch (Exception e) {
            throw new ParsingException("Could not get comment id", e);
        }
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        return this.getAuthorThumbnails();
    }

    @Override
    public boolean isHeartedByUploader() {
        JsonObject commentActionButtonsRenderer = this.commentRenderer.getObject("actionButtons").getObject("org.watermedia.shaded.commentActionButtonsRenderer");
        return commentActionButtonsRenderer.has("creatorHeart");
    }

    @Override
    public boolean isPinned() {
        return this.commentRenderer.has("pinnedCommentBadge");
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return this.commentRenderer.has("authorCommentBadge");
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return YoutubeParsingHelper.getTextFromObject(JsonUtils.getObject(this.commentRenderer, "authorText"));
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        try {
            return "https://www.youtube.com/channel/" + JsonUtils.getString(this.commentRenderer, "authorEndpoint.browseEndpoint.browseId");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getReplyCount() {
        if (this.commentRenderer.has("replyCount")) {
            return this.commentRenderer.getInt("replyCount");
        }
        return -1;
    }

    @Override
    public Page getReplies() {
        if (this.commentRepliesRenderer == null) {
            return null;
        }
        try {
            String id2 = JsonUtils.getString(JsonUtils.getArray(this.commentRepliesRenderer, "contents").getObject(0), "continuationItemRenderer.continuationEndpoint.continuationCommand.token");
            return new Page(this.url, id2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isChannelOwner() {
        return this.commentRenderer.getBoolean("authorIsChannelOwner");
    }

    @Override
    public boolean hasCreatorReply() {
        if (this.commentRepliesRenderer == null) {
            return false;
        }
        return this.commentRepliesRenderer.has("viewRepliesCreatorThumbnail");
    }
}

