/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonSink;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Response;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ContentNotAvailableException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ImageSuffix;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.JsonUtils;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubeMixPlaylistExtractor
extends PlaylistExtractor {
    private static final List<ImageSuffix> IMAGE_URL_SUFFIXES_AND_RESOLUTIONS = List.of(new ImageSuffix("default.jpg", 90, 120, Image.ResolutionLevel.LOW), new ImageSuffix("mqdefault.jpg", 180, 320, Image.ResolutionLevel.MEDIUM), new ImageSuffix("hqdefault.jpg", 360, 480, Image.ResolutionLevel.MEDIUM));
    public static final String COOKIE_NAME = "VISITOR_INFO1_LIVE";
    private JsonObject initialData;
    private JsonObject playlistData;
    private String cookieValue;

    public YoutubeMixPlaylistExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        Localization localization = this.getExtractorLocalization();
        URL url = Utils.stringToURL(this.getUrl());
        String mixPlaylistId = this.getId();
        String videoId = Utils.getQueryValue(url, "v");
        String playlistIndexString = Utils.getQueryValue(url, "index");
        JsonSink jsonBody = YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("playlistId", mixPlaylistId);
        if (videoId != null) {
            ((JsonBuilder)jsonBody).value("videoId", videoId);
        }
        if (playlistIndexString != null) {
            ((JsonBuilder)jsonBody).value("playlistIndex", Integer.parseInt(playlistIndexString));
        }
        byte[] body = JsonWriter.string(((JsonBuilder)jsonBody).done()).getBytes(StandardCharsets.UTF_8);
        Map<String, List<String>> headers = YoutubeParsingHelper.getYouTubeHeaders();
        Response response = this.getDownloader().postWithContentTypeJson("https://www.youtube.com/youtubei/v1/next?prettyPrint=false", headers, body, localization);
        this.initialData = JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(response));
        this.playlistData = this.initialData.getObject("contents").getObject("twoColumnWatchNextResults").getObject("playlist").getObject("playlist");
        if (Utils.isNullOrEmpty(this.playlistData)) {
            ExtractionException ex = new ExtractionException("Could not get playlistData");
            if (!YoutubeParsingHelper.isConsentAccepted()) {
                throw new ContentNotAvailableException("Consent is required in some countries to view Mix playlists", ex);
            }
            throw ex;
        }
        this.cookieValue = YoutubeParsingHelper.extractCookieValue(COOKIE_NAME, response);
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextAtKey(this.playlistData, "title");
        if (Utils.isNullOrEmpty(name)) {
            throw new ParsingException("Could not get playlist name");
        }
        return name;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        try {
            return this.getThumbnailsFromPlaylistId(this.playlistData.getString("playlistId"));
        }
        catch (Exception e) {
            try {
                return this.getThumbnailsFromVideoId(this.initialData.getObject("currentVideoEndpoint").getObject("watchEndpoint").getString("videoId"));
            }
            catch (Exception exception) {
                throw new ParsingException("Could not get playlist thumbnails", e);
            }
        }
    }

    @Override
    public String getUploaderUrl() {
        return "";
    }

    @Override
    public String getUploaderName() {
        return "YouTube";
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() {
        return List.of();
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public long getStreamCount() {
        return -2L;
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        return Description.EMPTY_DESCRIPTION;
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws IOException, ExtractionException {
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        this.collectStreamsFrom(collector, this.playlistData.getArray("contents"));
        HashMap<String, String> cookies = new HashMap<String, String>();
        cookies.put(COOKIE_NAME, this.cookieValue);
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, this.getNextPageFrom(this.playlistData, cookies));
    }

    @Nonnull
    private Page getNextPageFrom(@Nonnull JsonObject playlistJson, Map<String, String> cookies) throws IOException, ExtractionException {
        JsonObject lastStream = (JsonObject)playlistJson.getArray("contents").get(playlistJson.getArray("contents").size() - 1);
        if (lastStream == null || lastStream.getObject("playlistPanelVideoRenderer") == null) {
            throw new ExtractionException("Could not extract next page url");
        }
        JsonObject watchEndpoint = lastStream.getObject("playlistPanelVideoRenderer").getObject("navigationEndpoint").getObject("watchEndpoint");
        String playlistId = watchEndpoint.getString("playlistId");
        String videoId = watchEndpoint.getString("videoId");
        int index = watchEndpoint.getInt("index");
        String params = watchEndpoint.getString("params");
        byte[] body = JsonWriter.string(((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(this.getExtractorLocalization(), this.getExtractorContentCountry()).value("videoId", videoId)).value("playlistId", playlistId)).value("playlistIndex", index)).value("params", params)).done()).getBytes(StandardCharsets.UTF_8);
        return new Page("https://www.youtube.com/youtubei/v1/next?prettyPrint=false", null, null, cookies, body);
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        if (!page.getCookies().containsKey(COOKIE_NAME)) {
            throw new IllegalArgumentException("Cookie 'VISITOR_INFO1_LIVE' is missing");
        }
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        Map<String, List<String>> headers = YoutubeParsingHelper.getYouTubeHeaders();
        Response response = this.getDownloader().postWithContentTypeJson(page.getUrl(), headers, page.getBody(), this.getExtractorLocalization());
        JsonObject ajaxJson = JsonUtils.toJsonObject(YoutubeParsingHelper.getValidJsonResponseBody(response));
        JsonObject playlistJson = ajaxJson.getObject("contents").getObject("twoColumnWatchNextResults").getObject("playlist").getObject("playlist");
        JsonArray allStreams = playlistJson.getArray("contents");
        List<Object> newStreams = allStreams.subList(playlistJson.getInt("currentIndex") + 1, allStreams.size());
        this.collectStreamsFrom(collector, newStreams);
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, this.getNextPageFrom(playlistJson, page.getCookies()));
    }

    private void collectStreamsFrom(@Nonnull StreamInfoItemsCollector collector, @Nullable List<Object> streams) {
        if (streams == null) {
            return;
        }
        TimeAgoParser timeAgoParser = this.getTimeAgoParser();
        streams.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(stream -> stream.getObject("playlistPanelVideoRenderer")).filter(Objects::nonNull).map(streamInfo -> new YoutubeStreamInfoItemExtractor((JsonObject)streamInfo, timeAgoParser)).forEachOrdered(collector::commit);
    }

    @Nonnull
    private List<Image> getThumbnailsFromPlaylistId(@Nonnull String playlistId) throws ParsingException {
        return this.getThumbnailsFromVideoId(YoutubeParsingHelper.extractVideoIdFromMixId(playlistId));
    }

    @Nonnull
    private List<Image> getThumbnailsFromVideoId(@Nonnull String videoId) {
        String baseUrl = "https://i.ytimg.com/vi/" + videoId + "/";
        return IMAGE_URL_SUFFIXES_AND_RESOLUTIONS.stream().map(imageSuffix -> new Image(baseUrl + imageSuffix.getSuffix(), imageSuffix.getHeight(), imageSuffix.getWidth(), imageSuffix.getResolutionLevel())).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Nonnull
    public PlaylistInfo.PlaylistType getPlaylistType() throws ParsingException {
        return YoutubeParsingHelper.extractPlaylistTypeFromPlaylistId(this.playlistData.getString("playlistId"));
    }
}

