/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonBuilder;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.com.grack.nanojson.JsonWriter;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeReelInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors.YoutubeStreamInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.protos.playlist.PlaylistProtobufContinuation;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.Description;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.stream.StreamInfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubePlaylistExtractor
extends PlaylistExtractor {
    private static final String PLAYLIST_VIDEO_RENDERER = "playlistVideoRenderer";
    private static final String RICH_ITEM_RENDERER = "richItemRenderer";
    private static final String REEL_ITEM_RENDERER = "reelItemRenderer";
    private static final String SIDEBAR = "sidebar";
    private static final String HEADER = "header";
    private static final String VIDEO_OWNER_RENDERER = "videoOwnerRenderer";
    private static final String MICROFORMAT = "microformat";
    private static final String PLAYLIST_CONTINUATION_PROPERTIES_BASE64 = "CADCBgIIAA%3D%3D";
    private JsonObject browseMetadataResponse;
    private JsonObject initialBrowseContinuationResponse;
    private JsonObject playlistInfo;
    private JsonObject uploaderInfo;
    private JsonObject playlistHeader;
    private boolean isNewPlaylistInterface;

    public YoutubePlaylistExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Override
    public void onFetchPage(@Nonnull Downloader downloader) throws IOException, ExtractionException {
        String playlistId = this.getId();
        Localization localization = this.getExtractorLocalization();
        byte[] body = JsonWriter.string(((JsonBuilder)((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("browseId", "VL" + playlistId)).value("params", "wgYCCAA%3D")).done()).getBytes(StandardCharsets.UTF_8);
        this.browseMetadataResponse = YoutubeParsingHelper.getJsonPostResponse("browse", List.of("$fields=sidebar,header,microformat,alerts"), body, localization);
        YoutubeParsingHelper.defaultAlertsCheck(this.browseMetadataResponse);
        this.isNewPlaylistInterface = this.checkIfResponseIsNewPlaylistInterface();
        PlaylistProtobufContinuation.PlaylistContinuation playlistContinuation = (PlaylistProtobufContinuation.PlaylistContinuation)PlaylistProtobufContinuation.PlaylistContinuation.newBuilder().setParameters((PlaylistProtobufContinuation.ContinuationParams)PlaylistProtobufContinuation.ContinuationParams.newBuilder().setBrowseId("VL" + playlistId).setPlaylistId(playlistId).setContinuationProperties(PLAYLIST_CONTINUATION_PROPERTIES_BASE64).build()).build();
        this.initialBrowseContinuationResponse = YoutubeParsingHelper.getJsonPostResponse("browse", JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(localization, this.getExtractorContentCountry()).value("continuation", Utils.encodeUrlUtf8(Base64.getUrlEncoder().encodeToString(playlistContinuation.toByteArray())))).done()).getBytes(StandardCharsets.UTF_8), localization);
    }

    private boolean checkIfResponseIsNewPlaylistInterface() {
        return this.browseMetadataResponse.has(HEADER) && !this.browseMetadataResponse.has(SIDEBAR);
    }

    @Nonnull
    private JsonObject getUploaderInfo() throws ParsingException {
        if (this.uploaderInfo == null) {
            this.uploaderInfo = this.browseMetadataResponse.getObject(SIDEBAR).getObject("playlistSidebarRenderer").getArray("items").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(item -> item.getObject("playlistSidebarSecondaryInfoRenderer").getObject("videoOwner").has(VIDEO_OWNER_RENDERER)).map(item -> item.getObject("playlistSidebarSecondaryInfoRenderer").getObject("videoOwner").getObject(VIDEO_OWNER_RENDERER)).findFirst().orElseThrow(() -> new ParsingException("Could not get uploader info"));
        }
        return this.uploaderInfo;
    }

    @Nonnull
    private JsonObject getPlaylistInfo() throws ParsingException {
        if (this.playlistInfo == null) {
            this.playlistInfo = this.browseMetadataResponse.getObject(SIDEBAR).getObject("playlistSidebarRenderer").getArray("items").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(item -> item.has("playlistSidebarPrimaryInfoRenderer")).map(item -> item.getObject("playlistSidebarPrimaryInfoRenderer")).findFirst().orElseThrow(() -> new ParsingException("Could not get playlist info"));
        }
        return this.playlistInfo;
    }

    @Nonnull
    private JsonObject getPlaylistHeader() {
        if (this.playlistHeader == null) {
            this.playlistHeader = this.browseMetadataResponse.getObject(HEADER).getObject("playlistHeaderRenderer");
        }
        return this.playlistHeader;
    }

    @Override
    @Nonnull
    public String getName() throws ParsingException {
        String name = YoutubeParsingHelper.getTextFromObject(this.getPlaylistInfo().getObject("title"));
        if (!Utils.isNullOrEmpty(name)) {
            return name;
        }
        return this.browseMetadataResponse.getObject(MICROFORMAT).getObject("microformatDataRenderer").getString("title");
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        JsonArray playlistMetadataThumbnailsArray = this.isNewPlaylistInterface ? this.getPlaylistHeader().getObject("playlistHeaderBanner").getObject("heroPlaylistThumbnailRenderer").getObject("thumbnail").getArray("thumbnails") : this.playlistInfo.getObject("thumbnailRenderer").getObject("playlistVideoThumbnailRenderer").getObject("thumbnail").getArray("thumbnails");
        if (!Utils.isNullOrEmpty(playlistMetadataThumbnailsArray)) {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(playlistMetadataThumbnailsArray);
        }
        JsonArray microFormatThumbnailsArray = this.browseMetadataResponse.getObject(MICROFORMAT).getObject("microformatDataRenderer").getObject("thumbnail").getArray("thumbnails");
        if (!Utils.isNullOrEmpty(microFormatThumbnailsArray)) {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(microFormatThumbnailsArray);
        }
        throw new ParsingException("Could not get playlist thumbnails");
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        try {
            return YoutubeParsingHelper.getUrlFromNavigationEndpoint(this.isNewPlaylistInterface ? this.getPlaylistHeader().getObject("ownerText").getArray("runs").getObject(0).getObject("navigationEndpoint") : this.getUploaderInfo().getObject("navigationEndpoint"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist uploader url", e);
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return YoutubeParsingHelper.getTextFromObject(this.isNewPlaylistInterface ? this.getPlaylistHeader().getObject("ownerText") : this.getUploaderInfo().getObject("title"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist uploader name", e);
        }
    }

    @Override
    @Nonnull
    public List<Image> getUploaderAvatars() throws ParsingException {
        if (this.isNewPlaylistInterface) {
            return List.of();
        }
        try {
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(this.getUploaderInfo().getObject("thumbnail").getArray("thumbnails"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get playlist uploader avatars", e);
        }
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        return false;
    }

    @Override
    public long getStreamCount() throws ParsingException {
        String statsText;
        String briefsStatsText;
        JsonArray briefStats;
        if (this.isNewPlaylistInterface) {
            String firstByLineRendererText;
            String numVideosText = YoutubeParsingHelper.getTextFromObject(this.getPlaylistHeader().getObject("numVideosText"));
            if (numVideosText != null) {
                try {
                    return Long.parseLong(Utils.removeNonDigitCharacters(numVideosText));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((firstByLineRendererText = YoutubeParsingHelper.getTextFromObject(this.getPlaylistHeader().getArray("byline").getObject(0).getObject("text"))) != null) {
                try {
                    return Long.parseLong(Utils.removeNonDigitCharacters(firstByLineRendererText));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!(briefStats = (this.isNewPlaylistInterface ? this.getPlaylistHeader() : this.getPlaylistInfo()).getArray("briefStats")).isEmpty() && (briefsStatsText = YoutubeParsingHelper.getTextFromObject(briefStats.getObject(0))) != null) {
            return Long.parseLong(Utils.removeNonDigitCharacters(briefsStatsText));
        }
        JsonArray stats = (this.isNewPlaylistInterface ? this.getPlaylistHeader() : this.getPlaylistInfo()).getArray("stats");
        if (!stats.isEmpty() && (statsText = YoutubeParsingHelper.getTextFromObject(stats.getObject(0))) != null) {
            return Long.parseLong(Utils.removeNonDigitCharacters(statsText));
        }
        return -1L;
    }

    @Override
    @Nonnull
    public Description getDescription() throws ParsingException {
        String description = YoutubeParsingHelper.getTextFromObject(this.getPlaylistInfo().getObject("description"), true);
        return new Description(description, 1);
    }

    @Override
    @Nonnull
    public ListExtractor.InfoItemsPage<StreamInfoItem> getInitialPage() throws IOException, ExtractionException {
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        JsonArray initialItems = this.initialBrowseContinuationResponse.getArray("onResponseReceivedActions").getObject(0).getObject("reloadContinuationItemsCommand").getArray("continuationItems");
        this.collectStreamsFrom(collector, initialItems);
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, this.getNextPageFrom(initialItems));
    }

    @Override
    public ListExtractor.InfoItemsPage<StreamInfoItem> getPage(Page page) throws IOException, ExtractionException {
        if (page == null || Utils.isNullOrEmpty(page.getUrl())) {
            throw new IllegalArgumentException("Page doesn't contain an URL");
        }
        StreamInfoItemsCollector collector = new StreamInfoItemsCollector(this.getServiceId());
        JsonObject ajaxJson = YoutubeParsingHelper.getJsonPostResponse("browse", page.getBody(), this.getExtractorLocalization());
        JsonArray continuation = ajaxJson.getArray("onResponseReceivedActions").getObject(0).getObject("appendContinuationItemsAction").getArray("continuationItems");
        this.collectStreamsFrom(collector, continuation);
        return new ListExtractor.InfoItemsPage<StreamInfoItem>(collector, this.getNextPageFrom(continuation));
    }

    @Nullable
    private Page getNextPageFrom(JsonArray contents) throws IOException, ExtractionException {
        if (Utils.isNullOrEmpty(contents)) {
            return null;
        }
        JsonObject lastElement = contents.getObject(contents.size() - 1);
        if (lastElement.has("continuationItemRenderer")) {
            JsonObject continuationEndpoint = lastElement.getObject("continuationItemRenderer").getObject("continuationEndpoint");
            JsonObject continuationObject = continuationEndpoint.has("org.watermedia.shaded.commandExecutorCommand") ? continuationEndpoint.getObject("org.watermedia.shaded.commandExecutorCommand").getArray("org.watermedia.shaded.commands").stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(command -> command.has("continuationCommand")).findFirst().orElse(new JsonObject()) : continuationEndpoint;
            String continuation = continuationObject.getObject("continuationCommand").getString("token");
            if (Utils.isNullOrEmpty(continuation)) {
                return null;
            }
            byte[] body = JsonWriter.string(((JsonBuilder)YoutubeParsingHelper.prepareDesktopJsonBuilder(this.getExtractorLocalization(), this.getExtractorContentCountry()).value("continuation", continuation)).done()).getBytes(StandardCharsets.UTF_8);
            return new Page("https://www.youtube.com/youtubei/v1/browse?prettyPrint=false", body);
        }
        return null;
    }

    private void collectStreamsFrom(@Nonnull StreamInfoItemsCollector collector, @Nonnull JsonArray videos) {
        TimeAgoParser timeAgoParser = this.getTimeAgoParser();
        videos.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(video -> {
            JsonObject richItemRendererContent;
            JsonObject richItemRenderer;
            if (video.has(PLAYLIST_VIDEO_RENDERER)) {
                collector.commit(new YoutubeStreamInfoItemExtractor(video.getObject(PLAYLIST_VIDEO_RENDERER), timeAgoParser));
            } else if (video.has(RICH_ITEM_RENDERER) && (richItemRenderer = video.getObject(RICH_ITEM_RENDERER)).has("content") && (richItemRendererContent = richItemRenderer.getObject("content")).has(REEL_ITEM_RENDERER)) {
                collector.commit(new YoutubeReelInfoItemExtractor(richItemRendererContent.getObject(REEL_ITEM_RENDERER)));
            }
        });
    }

    @Override
    @Nonnull
    public PlaylistInfo.PlaylistType getPlaylistType() throws ParsingException {
        return YoutubeParsingHelper.extractPlaylistTypeFromPlaylistUrl(this.getUrl());
    }
}

