/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.extractors;

import java.util.List;
import org.watermedia.shaded.com.grack.nanojson.JsonArray;
import org.watermedia.shaded.com.grack.nanojson.JsonObject;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.schabi.newpipe.extractor.Image;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.playlist.PlaylistInfoItemExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.YoutubeParsingHelper;
import org.watermedia.shaded.schabi.newpipe.extractor.services.youtube.linkHandler.YoutubePlaylistLinkHandlerFactory;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Utils;

public class YoutubePlaylistInfoItemExtractor
implements PlaylistInfoItemExtractor {
    private final JsonObject playlistInfoItem;

    public YoutubePlaylistInfoItemExtractor(JsonObject playlistInfoItem) {
        this.playlistInfoItem = playlistInfoItem;
    }

    @Override
    @Nonnull
    public List<Image> getThumbnails() throws ParsingException {
        try {
            JsonArray thumbnails = this.playlistInfoItem.getArray("thumbnails").getObject(0).getArray("thumbnails");
            if (thumbnails.isEmpty()) {
                thumbnails = this.playlistInfoItem.getObject("thumbnail").getArray("thumbnails");
            }
            return YoutubeParsingHelper.getImagesFromThumbnailsArray(thumbnails);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get thumbnails", e);
        }
    }

    @Override
    public String getName() throws ParsingException {
        try {
            return YoutubeParsingHelper.getTextFromObject(this.playlistInfoItem.getObject("title"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get name", e);
        }
    }

    @Override
    public String getUrl() throws ParsingException {
        try {
            String id2 = this.playlistInfoItem.getString("playlistId");
            return YoutubePlaylistLinkHandlerFactory.getInstance().getUrl(id2);
        }
        catch (Exception e) {
            throw new ParsingException("Could not get url", e);
        }
    }

    @Override
    public String getUploaderName() throws ParsingException {
        try {
            return YoutubeParsingHelper.getTextFromObject(this.playlistInfoItem.getObject("longBylineText"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get uploader name", e);
        }
    }

    @Override
    public String getUploaderUrl() throws ParsingException {
        try {
            return YoutubeParsingHelper.getUrlFromObject(this.playlistInfoItem.getObject("longBylineText"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get uploader url", e);
        }
    }

    @Override
    public boolean isUploaderVerified() throws ParsingException {
        try {
            return YoutubeParsingHelper.isVerified(this.playlistInfoItem.getArray("ownerBadges"));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get uploader verification info", e);
        }
    }

    @Override
    public long getStreamCount() throws ParsingException {
        String videoCountText = this.playlistInfoItem.getString("videoCount");
        if (videoCountText == null) {
            videoCountText = YoutubeParsingHelper.getTextFromObject(this.playlistInfoItem.getObject("videoCountText"));
        }
        if (videoCountText == null) {
            videoCountText = YoutubeParsingHelper.getTextFromObject(this.playlistInfoItem.getObject("videoCountShortText"));
        }
        if (videoCountText == null) {
            throw new ParsingException("Could not get stream count");
        }
        try {
            return Long.parseLong(Utils.removeNonDigitCharacters(videoCountText));
        }
        catch (Exception e) {
            throw new ParsingException("Could not get stream count", e);
        }
    }
}

