/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.Pair;

public final class ManifestCreatorCache<K extends Serializable, V extends Serializable>
implements Serializable {
    public static final int DEFAULT_MAXIMUM_SIZE = Integer.MAX_VALUE;
    public static final double DEFAULT_CLEAR_FACTOR = 0.75;
    private final ConcurrentHashMap<K, Pair<Integer, V>> concurrentHashMap;
    private int maximumSize = Integer.MAX_VALUE;
    private double clearFactor = 0.75;

    public ManifestCreatorCache() {
        this.concurrentHashMap = new ConcurrentHashMap();
    }

    public boolean containsKey(K key) {
        return this.concurrentHashMap.containsKey(key);
    }

    @Nullable
    public Pair<Integer, V> get(K key) {
        return this.concurrentHashMap.get(key);
    }

    @Nullable
    public V put(K key, V value) {
        Pair<Integer, V> returnValue;
        if (!this.concurrentHashMap.containsKey(key) && this.concurrentHashMap.size() == this.maximumSize) {
            int newCacheSize = (int)Math.round((double)this.maximumSize * this.clearFactor);
            this.keepNewestEntries(newCacheSize != 0 ? newCacheSize : 1);
        }
        return (returnValue = this.concurrentHashMap.put(key, new Pair<Integer, V>(this.concurrentHashMap.size(), value))) == null ? null : (V)returnValue.getSecond();
    }

    public void clear() {
        this.concurrentHashMap.clear();
    }

    public void reset() {
        this.clear();
        this.resetClearFactor();
        this.resetMaximumSize();
    }

    public int size() {
        return this.concurrentHashMap.size();
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        if (maximumSize <= 0) {
            throw new IllegalArgumentException("Invalid maximum size");
        }
        if (maximumSize < this.maximumSize && !this.concurrentHashMap.isEmpty()) {
            int newCacheSize = (int)Math.round((double)maximumSize * this.clearFactor);
            this.keepNewestEntries(newCacheSize != 0 ? newCacheSize : 1);
        }
        this.maximumSize = maximumSize;
    }

    public void resetMaximumSize() {
        this.maximumSize = Integer.MAX_VALUE;
    }

    public double getClearFactor() {
        return this.clearFactor;
    }

    public void setClearFactor(double clearFactor) {
        if (clearFactor <= 0.0 || clearFactor >= 1.0) {
            throw new IllegalArgumentException("Invalid clear factor");
        }
        this.clearFactor = clearFactor;
    }

    public void resetClearFactor() {
        this.clearFactor = 0.75;
    }

    @Nonnull
    public String toString() {
        return "ManifestCreatorCache[clearFactor=" + this.clearFactor + ", maximumSize=" + this.maximumSize + ", concurrentHashMap=" + this.concurrentHashMap + "]";
    }

    private void keepNewestEntries(int newLimit) {
        int difference = this.concurrentHashMap.size() - newLimit;
        ArrayList<Map.Entry> entriesToRemove = new ArrayList<Map.Entry>();
        this.concurrentHashMap.entrySet().forEach(entry -> {
            Pair value = (Pair)entry.getValue();
            if ((Integer)value.getFirst() < difference) {
                entriesToRemove.add((Map.Entry)entry);
            } else {
                value.setFirst((Integer)value.getFirst() - difference);
            }
        });
        entriesToRemove.forEach(entry -> this.concurrentHashMap.remove(entry.getKey(), entry.getValue()));
    }
}

