/*
 * Decompiled with CFR 0.152.
 */
package com.kleiders.woodenelytra;

import com.kleiders.woodenelytra.WoodenElytraClientConfigs;
import com.kleiders.woodenelytra.WoodenElytraCommonConfigs;
import com.kleiders.woodenelytra.WoodenElytraItem;
import com.kleiders.woodenelytra.WoodenElytraLayer;
import com.kleiders.woodenelytra.init.WoodenElytraModParticleTypes;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="wooden_elytra")
public class WoodenElytraMod {
    public static final Logger LOGGER = LogManager.getLogger(WoodenElytraMod.class);
    public static final String MODID = "wooden_elytra";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("wooden_elytra", "wooden_elytra"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;

    public WoodenElytraMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)WoodenElytraClientConfigs.SPEC, "woodenelytra-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WoodenElytraCommonConfigs.SPEC, "woodenelytra-common.toml");
        WoodenElytraItem.ITEMS.register(bus);
        bus.addListener(this::onClientSetup);
        if (FMLEnvironment.dist.isClient()) {
            bus.addListener(this::registerElytraLayer);
        }
        WoodenElytraModParticleTypes.REGISTRY.register(bus);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerElytraLayer(EntityRenderersEvent event) {
        if (event instanceof EntityRenderersEvent.AddLayers) {
            EntityRenderersEvent.AddLayers addLayersEvent = (EntityRenderersEvent.AddLayers)event;
            EntityModelSet entityModels = addLayersEvent.getEntityModels();
            addLayersEvent.getSkins().forEach(s -> {
                LivingEntityRenderer livingEntityRenderer = addLayersEvent.getSkin(s);
                if (livingEntityRenderer instanceof PlayerRenderer) {
                    PlayerRenderer playerRenderer = (PlayerRenderer)livingEntityRenderer;
                    playerRenderer.m_115326_((RenderLayer)new WoodenElytraLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)playerRenderer, entityModels));
                }
            });
        }
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }
}

