/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block;

import com.starfish_studios.yaf.block.entity.MailboxBlockEntity;
import com.starfish_studios.yaf.block.properties.FlagStatus;
import com.starfish_studios.yaf.inventory.MailboxMenu;
import com.starfish_studios.yaf.registry.YAFBlockEntities;
import com.starfish_studios.yaf.world.YAFSavedData;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<FlagStatus> FLAG_STATUS = EnumProperty.m_61587_((String)"flag", FlagStatus.class);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty FENCE_BELOW = BooleanProperty.m_61465_((String)"fence_below");
    public static final VoxelShape NORTH_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    public static final VoxelShape NORTH_FENCE_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)-7.0, (double)12.0, (double)12.0, (double)10.0);
    public static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final VoxelShape EAST_FENCE_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)23.0, (double)12.0, (double)12.0);
    public static final VoxelShape SOUTH_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    public static final VoxelShape SOUTH_FENCE_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)12.0, (double)23.0);
    public static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final VoxelShape WEST_FENCE_AABB = Block.m_49796_((double)-7.0, (double)0.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0);

    public MailboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(FLAG_STATUS, (Comparable)((Object)FlagStatus.DOWN))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FENCE_BELOW, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> {
                if (((Boolean)blockState.m_61143_((Property)FENCE_BELOW)).booleanValue()) {
                    yield NORTH_FENCE_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.EAST -> {
                if (((Boolean)blockState.m_61143_((Property)FENCE_BELOW)).booleanValue()) {
                    yield EAST_FENCE_AABB;
                }
                yield EAST_AABB;
            }
            case Direction.SOUTH -> {
                if (((Boolean)blockState.m_61143_((Property)FENCE_BELOW)).booleanValue()) {
                    yield SOUTH_FENCE_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.WEST -> (Boolean)blockState.m_61143_((Property)FENCE_BELOW) != false ? WEST_FENCE_AABB : WEST_AABB;
        };
    }

    public BlockState open(BlockState blockState, Level level, BlockPos blockPos) {
        blockState = (BlockState)blockState.m_61122_((Property)OPEN);
        level.m_7731_(blockPos, blockState, 3);
        return blockState;
    }

    public InteractionResult m_6227_(BlockState state, Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(pos);
            MailboxBlockEntity mailboxBlockEntity = (MailboxBlockEntity)blockEntity;
            if (player.m_6144_()) {
                if (state.m_61143_(FLAG_STATUS) == FlagStatus.DOWN) {
                    assert (blockEntity != null);
                    player.m_5661_((Component)Component.m_237110_((String)"yaf.mailbox.sending", (Object[])new Object[]{mailboxBlockEntity.getMailboxName(), "XYZ: " + pos.m_123341_() + " / " + pos.m_123342_() + " / " + pos.m_123343_()}).m_130940_(ChatFormatting.GREEN).m_130940_(ChatFormatting.ITALIC), true);
                } else if (state.m_61143_(FLAG_STATUS) == FlagStatus.UP) {
                    assert (blockEntity != null);
                    player.m_5661_((Component)Component.m_237110_((String)"yaf.mailbox.receiving", (Object[])new Object[]{mailboxBlockEntity.getMailboxName(), "XYZ: " + pos.m_123341_() + " / " + pos.m_123342_() + " / " + pos.m_123343_()}).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC), true);
                }
                BlockState blockState2 = this.open(state, level, pos);
                float f = blockState2.m_61143_(FLAG_STATUS) == FlagStatus.UP ? 0.5f : 0.6f;
                level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, f);
                level.m_7731_(pos, (BlockState)state.m_61122_(FLAG_STATUS), 3);
            } else if (blockEntity instanceof MailboxBlockEntity) {
                final MailboxBlockEntity mailboxBlockEntity1 = (MailboxBlockEntity)blockEntity;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                        public void saveExtraData(FriendlyByteBuf buf) {
                            buf.m_130064_(pos.m_7949_());
                        }

                        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                            this.saveExtraData(buf);
                            return new MailboxMenu(id, inventory, buf);
                        }

                        public Component m_5446_() {
                            return mailboxBlockEntity1.m_5446_();
                        }
                    });
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return MailboxBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)YAFBlockEntities.MAILBOX.get()), MailboxBlockEntity::sendItemsTick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.m_61104_(new Property[]{FACING, WATERLOGGED, FLAG_STATUS, OPEN, FENCE_BELOW});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_(FLAG_STATUS, (Comparable)((Object)FlagStatus.DOWN))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FENCE_BELOW, (Comparable)Boolean.valueOf(context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_204336_(BlockTags.f_13039_)));
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            FlagStatus newStatus;
            boolean isPowered = level.m_276867_(pos);
            FlagStatus flagStatus = newStatus = isPowered ? FlagStatus.UP : FlagStatus.DOWN;
            if (state.m_61143_(FLAG_STATUS) != newStatus) {
                level.m_7731_(pos, (BlockState)state.m_61124_(FLAG_STATUS, (Comparable)((Object)newStatus)), 3);
                float pitch = newStatus == FlagStatus.UP ? 0.6f : 0.5f;
                level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, pitch);
            }
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((Container)blockEntity));
                level.m_46717_(blockPos, (Block)this);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                YAFSavedData mailboxes = YAFSavedData.getMailboxes(serverLevel);
                GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)blockPos);
                mailboxes.mailboxes.removeIf(entry -> entry.globalPos().equals((Object)globalPos));
                mailboxes.m_77762_();
            }
            super.m_6810_(blockState, level, blockPos, blockState2, bl);
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        Player player = livingEntity instanceof Player ? (Player)livingEntity : null;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof MailboxBlockEntity) {
            if (player != null && !itemStack.m_41788_()) {
                ((MailboxBlockEntity)blockEntity).setCustomName((Component)Component.m_237110_((String)"container.mailbox.player_name", (Object[])new Object[]{player.m_5446_()}));
            } else if (itemStack.m_41788_()) {
                ((MailboxBlockEntity)blockEntity).setCustomName(itemStack.m_41786_());
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                YAFSavedData mailboxes = YAFSavedData.getMailboxes(serverLevel);
                GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)blockPos);
                mailboxes.mailboxes.add(new YAFSavedData.MailboxData(player != null ? player.m_5446_().getString() : "PlayerName", itemStack.m_41788_() ? itemStack.m_41786_().getString() : "PlayerMailbox", globalPos));
                mailboxes.m_77762_();
            }
        }
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
        if (blockEntity instanceof MailboxBlockEntity) {
            MailboxBlockEntity mailboxBlockEntity = (MailboxBlockEntity)blockEntity;
            mailboxBlockEntity.recheckOpen();
        }
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new MailboxBlockEntity(blockPos, blockState);
    }
}

