/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.block.entity;

import com.starfish_studios.yaf.registry.YAFBlockEntities;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WindChimeBlockEntity
extends BlockEntity {
    private final Random random = new Random();
    private int tickCounter = 0;
    private int animateTicksRemaining = 0;
    private float animationProgress = 0.0f;
    private static final int FADE_IN_TICKS = 15;
    private static final int FADE_OUT_TICKS = 40;
    private final SwingData baseSwingX = new SwingData();
    private final SwingData baseSwingZ = new SwingData();
    private final SwingData[] chimeSwingsX = new SwingData[4];
    private final SwingData[] chimeSwingsZ = new SwingData[4];
    private final SwingData idleBaseSwingX = new SwingData();
    private final SwingData idleBaseSwingZ = new SwingData();
    private final SwingData[] idleChimeSwingsX = new SwingData[4];
    private final SwingData[] idleChimeSwingsZ = new SwingData[4];
    private int idleTickCounter = 0;
    private boolean idleTickFlip = false;

    public WindChimeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)YAFBlockEntities.CHIME.get(), pos, state);
        this.randomize();
    }

    private void randomize() {
        int i;
        this.baseSwingX.randomizeBase(this.random);
        this.baseSwingZ.randomizeBase(this.random);
        for (i = 0; i < 4; ++i) {
            this.chimeSwingsX[i] = new SwingData();
            this.chimeSwingsZ[i] = new SwingData();
            this.chimeSwingsX[i].randomizeChime(this.random, this.baseSwingX);
            this.chimeSwingsZ[i].randomizeChime(this.random, this.baseSwingZ);
        }
        this.idleBaseSwingX.randomizeBase(this.random);
        this.idleBaseSwingZ.randomizeBase(this.random);
        for (i = 0; i < 4; ++i) {
            this.idleChimeSwingsX[i] = new SwingData();
            this.idleChimeSwingsZ[i] = new SwingData();
            this.idleChimeSwingsX[i].randomizeChime(this.random, this.idleBaseSwingX);
            this.idleChimeSwingsZ[i].randomizeChime(this.random, this.idleBaseSwingZ);
        }
    }

    public void triggerAnimate(int ticks) {
        this.animateTicksRemaining = Math.max(this.animateTicksRemaining, Math.max(0, ticks));
    }

    public void commonTick(Level level, BlockState state) {
        if (level.f_46443_ && level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            this.clientTick(clientLevel);
        }
    }

    public void clientTick(ClientLevel clientLevel) {
        int i;
        boolean active = this.animateTicksRemaining > 0;
        this.animationProgress = active ? Math.min(1.0f, this.animationProgress + 0.06666667f) : Math.max(0.0f, this.animationProgress - 0.025f);
        boolean bl = this.idleTickFlip = !this.idleTickFlip;
        if (this.idleTickFlip) {
            ++this.idleTickCounter;
        }
        this.idleBaseSwingX.update(this.idleTickCounter, 0.006f, clientLevel.f_46441_);
        this.idleBaseSwingZ.update(this.idleTickCounter, 0.006f, clientLevel.f_46441_);
        for (i = 0; i < 4; ++i) {
            float idleFactor = 0.25f + (float)i * 0.03f;
            this.idleChimeSwingsX[i].update(this.idleTickCounter, idleFactor, clientLevel.f_46441_);
            this.idleChimeSwingsZ[i].update(this.idleTickCounter, idleFactor, clientLevel.f_46441_);
        }
        if (this.animationProgress > 0.0f || active) {
            ++this.tickCounter;
            this.baseSwingX.update(this.tickCounter, 0.01f, clientLevel.f_46441_);
            this.baseSwingZ.update(this.tickCounter, 0.01f, clientLevel.f_46441_);
            for (i = 0; i < 4; ++i) {
                float boundFactor = 0.7f + (float)i * 0.1f;
                this.chimeSwingsX[i].update(this.tickCounter, boundFactor, clientLevel.f_46441_);
                this.chimeSwingsZ[i].update(this.tickCounter, boundFactor, clientLevel.f_46441_);
            }
        }
        if (this.animateTicksRemaining > 0) {
            --this.animateTicksRemaining;
        }
    }

    public float getBaseSwingAngleX(float partialTick) {
        return this.baseSwingX.getInterpolatedAngle(partialTick);
    }

    public float getBaseSwingAngleZ(float partialTick) {
        return this.baseSwingZ.getInterpolatedAngle(partialTick);
    }

    public float getChimeSwingAngleX(int index, float partialTick) {
        return this.chimeSwingsX[index].getInterpolatedAngle(partialTick);
    }

    public float getChimeSwingAngleZ(int index, float partialTick) {
        return this.chimeSwingsZ[index].getInterpolatedAngle(partialTick);
    }

    public float getIdleBaseSwingAngleX(float partialTick) {
        return this.idleBaseSwingX.getInterpolatedAngle(partialTick);
    }

    public float getIdleBaseSwingAngleZ(float partialTick) {
        return this.idleBaseSwingZ.getInterpolatedAngle(partialTick);
    }

    public float getIdleChimeSwingAngleX(int index, float partialTick) {
        return this.idleChimeSwingsX[index].getInterpolatedAngle(partialTick);
    }

    public float getIdleChimeSwingAngleZ(int index, float partialTick) {
        return this.idleChimeSwingsZ[index].getInterpolatedAngle(partialTick);
    }

    public float getAnimationFactor() {
        float t = Mth.m_14036_((float)this.animationProgress, (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    private static class SwingData {
        private static final float BASE_SPEED = 0.095f;
        private static final int RANDOM_TICK_INTERVAL = 200;
        private static final float DEGREE_MOD = 4.2f;
        private float currentAngle = 0.0f;
        private float previousAngle = 0.0f;
        private float swingSpeed;
        private float swingOffset;
        private float targetSpeed;
        private float targetOffset;

        private SwingData() {
        }

        void randomizeBase(Random random) {
            this.swingSpeed = 0.095f + random.nextFloat() * 0.095f;
            this.swingOffset = random.nextFloat() * ((float)Math.PI * 2);
            this.targetSpeed = this.swingSpeed;
            this.targetOffset = this.swingOffset;
        }

        void randomizeChime(Random random, SwingData base) {
            this.swingSpeed = base.swingSpeed + random.nextFloat() * 0.0125f;
            this.swingOffset = random.nextFloat() * ((float)Math.PI * 2);
            this.targetSpeed = this.swingSpeed;
            this.targetOffset = this.swingOffset;
        }

        void update(int tickCounter, float boundFactor, RandomSource random) {
            if (tickCounter % 200 == 0) {
                this.targetSpeed = 0.095f + random.m_188501_() * 0.095f;
                this.targetOffset = random.m_188501_() * ((float)Math.PI * 2);
            }
            this.swingSpeed = Mth.m_14179_((float)0.005f, (float)this.swingSpeed, (float)this.targetSpeed);
            this.swingOffset = Mth.m_14179_((float)0.005f, (float)this.swingOffset, (float)this.targetOffset);
            float targetAngle = Mth.m_14031_((float)((float)tickCounter * this.swingSpeed + this.swingOffset)) * (4.2f * boundFactor);
            this.previousAngle = this.currentAngle;
            this.currentAngle = targetAngle;
        }

        float getInterpolatedAngle(float partialTick) {
            return Mth.m_14179_((float)partialTick, (float)this.previousAngle, (float)this.currentAngle);
        }
    }
}

