/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.yaf.util;

import com.starfish_studios.yaf.block.entity.FanBlockEntity;
import com.starfish_studios.yaf.registry.YAFSoundEvents;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

public class YAFSoundInstance
extends AbstractTickableSoundInstance {
    private static final Set<FanBlockEntity> activeSounds = Collections.newSetFromMap(new WeakHashMap());
    private final FanBlockEntity fan;
    private final int fadeDuration = 40;
    private int fadeInTicks = 1;
    private int fadeOutTicks = 0;
    private boolean fadingOut = false;

    public YAFSoundInstance(FanBlockEntity fan, SoundEvent soundEvent, RandomSource randomSource) {
        super(soundEvent, SoundSource.BLOCKS, randomSource);
        this.fan = fan;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119575_ = (double)fan.m_58899_().m_123341_() + 0.5;
        this.f_119576_ = (double)fan.m_58899_().m_123342_() + 0.5;
        this.f_119577_ = (double)fan.m_58899_().m_123343_() + 0.5;
    }

    public static void tryPlay(FanBlockEntity fan) {
        if (!activeSounds.contains((Object)fan)) {
            YAFSoundInstance instance = new YAFSoundInstance(fan, (SoundEvent)YAFSoundEvents.FAN_AMBIENCE.get(), SoundInstance.m_235150_());
            Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)instance);
            activeSounds.add(fan);
        }
    }

    public static void stop(FanBlockEntity fan) {
        activeSounds.remove((Object)fan);
    }

    public void m_7788_() {
        if (this.fan.m_58901_() || !this.fan.fanOn) {
            if (!this.fadingOut) {
                this.fadingOut = true;
                this.fadeOutTicks = 0;
            }
            ++this.fadeOutTicks;
            if (this.fadeOutTicks >= 40) {
                this.m_119609_();
                YAFSoundInstance.stop(this.fan);
            }
        } else {
            if (this.fadingOut) {
                this.fadingOut = false;
                this.fadeOutTicks = 0;
            }
            if (this.fadeInTicks < 40) {
                ++this.fadeInTicks;
            }
        }
    }

    public float m_7769_() {
        float factor = this.fadingOut ? 1.0f - (float)this.fadeOutTicks / 40.0f : (this.fadeInTicks < 40 ? (float)this.fadeInTicks / 40.0f : 1.0f);
        float baseVolume = 0.5f;
        return baseVolume * factor * this.f_119570_.m_235146_().m_214084_(this.f_235066_);
    }

    public boolean m_7767_() {
        return !this.fan.m_58901_() && (this.fan.fanOn || this.fadingOut);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SoundInstance.Attenuation m_7438_() {
        return SoundInstance.Attenuation.LINEAR;
    }
}

